/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.core.FunctionFactoryMetadata;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class FunctionContextUtils {
    public static Type findType(String name, ConfigurableListableBeanFactory registry) {
        return FunctionContextUtils.findType(registry, name);
    }

    public static Type findType(ConfigurableListableBeanFactory registry, String ... names) {
        AbstractBeanDefinition definition = null;
        String actualName = null;
        for (String name : names) {
            if (registry.containsBeanDefinition(name)) {
                definition = (AbstractBeanDefinition)registry.getBeanDefinition(name);
                actualName = name;
                continue;
            }
            if (!registry.containsBean(name)) continue;
            return FunctionTypeUtils.discoverFunctionTypeFromClass(registry.getBean(name).getClass());
        }
        if (definition == null) {
            return null;
        }
        if (definition instanceof ScannedGenericBeanDefinition) {
            try {
                return FunctionTypeUtils.discoverFunctionTypeFromClass(definition.getBeanClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object source = definition.getSource();
        Type param = null;
        if (source instanceof MethodMetadata) {
            param = FunctionContextUtils.findBeanType(definition, ((MethodMetadata)source).getDeclaringClassName(), ((MethodMetadata)source).getMethodName());
        } else if (source instanceof Resource) {
            param = registry.getType(actualName);
        } else {
            ResolvableType type = (ResolvableType)FunctionContextUtils.getField(definition, "targetType");
            if (type != null) {
                param = type.getType();
            } else {
                Class beanClass;
                Class clazz = beanClass = definition.hasBeanClass() ? definition.getBeanClass() : null;
                if (beanClass != null && !FunctionFactoryMetadata.class.isAssignableFrom(beanClass)) {
                    param = beanClass;
                } else {
                    Object bean = registry.getBean(actualName);
                    if (bean instanceof FunctionFactoryMetadata) {
                        param = ((FunctionFactoryMetadata)bean).getFactoryMethod().getGenericReturnType();
                    }
                }
            }
        }
        if (!(param instanceof ParameterizedType) && definition.hasBeanClass()) {
            return FunctionTypeUtils.discoverFunctionTypeFromClass(definition.getBeanClass());
        }
        return param;
    }

    public static Class<?>[] getParamTypesFromBeanDefinitionFactory(Class<?> factory, AbstractBeanDefinition definition) {
        if (definition instanceof RootBeanDefinition) {
            RootBeanDefinition root = (RootBeanDefinition)definition;
            for (Method method : FunctionContextUtils.getCandidateMethods(factory, root)) {
                if (!root.isFactoryMethod(method)) continue;
                return method.getParameterTypes();
            }
        }
        ArrayList<Class> params = new ArrayList<Class>();
        for (ConstructorArgumentValues.ValueHolder holder : definition.getConstructorArgumentValues().getIndexedArgumentValues().values()) {
            params.add(ClassUtils.resolveClassName((String)holder.getType(), null));
        }
        return params.toArray(new Class[0]);
    }

    private static Type findBeanType(AbstractBeanDefinition definition, String declaringClassName, String methodName) {
        Class factory = ClassUtils.resolveClassName((String)declaringClassName, null);
        Class[] params = FunctionContextUtils.getParamTypesFromBeanDefinitionFactory(factory, definition);
        Method method = ReflectionUtils.findMethod((Class)factory, (String)methodName, (Class[])params);
        Type type = method.getGenericReturnType();
        return type;
    }

    private static Method[] getCandidateMethods(final Class<?> factoryClass, final RootBeanDefinition mbd) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods((Class)factoryClass) : factoryClass.getMethods();
                }
            });
        }
        return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }

    private static Object getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }
}

