/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.processor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.processor.ExtensionStorage;
import org.pf4j.processor.LegacyExtensionStorage;
import org.pf4j.util.ClassUtils;

public class ExtensionAnnotationProcessor
extends AbstractProcessor {
    private static final String STORAGE_CLASS_NAME = "pf4j.storageClassName";
    private Map<String, Set<String>> extensions = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> oldExtensions = new HashMap<String, Set<String>>();
    private ExtensionStorage storage;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.info("%s init", ExtensionAnnotationProcessor.class);
        this.storage = this.createStorage();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotationTypes = new HashSet<String>();
        annotationTypes.add(Extension.class.getName());
        return annotationTypes;
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        options.add(STORAGE_CLASS_NAME);
        return options;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        this.info("Processing @%s", Extension.class);
        for (Element element : roundEnv.getElementsAnnotatedWith(Extension.class)) {
            TypeElement extensionElement;
            List<TypeElement> extensionPointElements;
            if (!(element instanceof TypeElement) || !this.isExtension(element.asType()) || (extensionPointElements = this.findExtensionPoints(extensionElement = (TypeElement)element)).isEmpty()) continue;
            String extension = this.getBinaryName(extensionElement);
            for (TypeElement extensionPointElement : extensionPointElements) {
                String extensionPoint = this.getBinaryName(extensionPointElement);
                Set extensionPoints = this.extensions.computeIfAbsent(extensionPoint, k -> new TreeSet());
                extensionPoints.add(extension);
            }
        }
        this.oldExtensions = this.storage.read();
        for (Map.Entry entry : this.oldExtensions.entrySet()) {
            String extensionPoint = (String)entry.getKey();
            if (this.extensions.containsKey(extensionPoint)) {
                this.extensions.get(extensionPoint).addAll((Collection)entry.getValue());
                continue;
            }
            this.extensions.put(extensionPoint, (Set)entry.getValue());
        }
        this.storage.write(this.extensions);
        return false;
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    public void error(String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args));
    }

    public void error(Element element, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
    }

    public void info(String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format(message, args));
    }

    public void info(Element element, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format(message, args), element);
    }

    public String getBinaryName(TypeElement element) {
        return this.processingEnv.getElementUtils().getBinaryName(element).toString();
    }

    public Map<String, Set<String>> getExtensions() {
        return this.extensions;
    }

    public Map<String, Set<String>> getOldExtensions() {
        return this.oldExtensions;
    }

    private List<TypeElement> findExtensionPoints(TypeElement extensionElement) {
        List extensionPointClasses;
        ArrayList<TypeElement> extensionPointElements = new ArrayList<TypeElement>();
        AnnotationValue annotatedExtensionPoints = ClassUtils.getAnnotationValue(extensionElement, Extension.class, "points");
        List list = extensionPointClasses = annotatedExtensionPoints != null ? (List)annotatedExtensionPoints.getValue() : null;
        if (extensionPointClasses != null && !extensionPointClasses.isEmpty()) {
            for (AnnotationValue annotationValue : extensionPointClasses) {
                String extensionPointClassName = annotationValue.getValue().toString();
                TypeElement extensionPointElement = this.processingEnv.getElementUtils().getTypeElement(extensionPointClassName);
                extensionPointElements.add(extensionPointElement);
            }
        } else {
            boolean bl;
            for (TypeMirror typeMirror : extensionElement.getInterfaces()) {
                boolean isExtensionPoint2 = this.processingEnv.getTypeUtils().isSubtype(typeMirror, this.getExtensionPointType());
                if (!isExtensionPoint2) continue;
                TypeElement extensionPointElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                extensionPointElements.add(extensionPointElement);
            }
            TypeMirror superclass = extensionElement.getSuperclass();
            if (superclass.getKind() != TypeKind.NONE && (bl = this.processingEnv.getTypeUtils().isSubtype(superclass, this.getExtensionPointType()))) {
                TypeElement extensionPointElement = (TypeElement)((DeclaredType)superclass).asElement();
                extensionPointElements.add(extensionPointElement);
            }
        }
        return extensionPointElements;
    }

    private boolean isExtension(TypeMirror typeMirror) {
        return this.processingEnv.getTypeUtils().isAssignable(typeMirror, this.getExtensionPointType());
    }

    private TypeMirror getExtensionPointType() {
        return this.processingEnv.getElementUtils().getTypeElement(ExtensionPoint.class.getName()).asType();
    }

    private ExtensionStorage createStorage() {
        ExtensionStorage storage = null;
        String storageClassName = this.processingEnv.getOptions().get(STORAGE_CLASS_NAME);
        if (storageClassName == null) {
            storageClassName = System.getProperty(STORAGE_CLASS_NAME);
        }
        if (storageClassName != null) {
            try {
                Class<?> storageClass = this.getClass().getClassLoader().loadClass(storageClassName);
                Constructor<?> constructor = storageClass.getConstructor(ExtensionAnnotationProcessor.class);
                storage = (ExtensionStorage)constructor.newInstance(this);
            }
            catch (Exception e) {
                this.error(e.getMessage(), new Object[0]);
            }
        }
        if (storage == null) {
            storage = new LegacyExtensionStorage(this);
        }
        return storage;
    }
}

