/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pf4j.DefaultExtensionFactory;

public class SingletonExtensionFactory
extends DefaultExtensionFactory {
    private final List<String> extensionClassNames;
    private Map<String, Object> cache;

    public SingletonExtensionFactory(String ... extensionClassNames) {
        this.extensionClassNames = Arrays.asList(extensionClassNames);
        this.cache = new HashMap<String, Object>();
    }

    @Override
    public <T> T create(Class<T> extensionClass) {
        String extensionClassName = extensionClass.getName();
        if (this.cache.containsKey(extensionClassName)) {
            return (T)this.cache.get(extensionClassName);
        }
        T extension = super.create(extensionClass);
        if (this.extensionClassNames.isEmpty() || this.extensionClassNames.contains(extensionClassName)) {
            this.cache.put(extensionClassName, extension);
        }
        return extension;
    }
}

