/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.pf4j.PluginDependency;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    private static final String JAVA_PACKAGE_PREFIX = "java.";
    private static final String PLUGIN_PACKAGE_PREFIX = "org.pf4j.";
    private PluginManager pluginManager;
    private PluginDescriptor pluginDescriptor;
    private boolean parentFirst;

    public PluginClassLoader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader parent) {
        this(pluginManager, pluginDescriptor, parent, false);
    }

    public PluginClassLoader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader parent, boolean parentFirst) {
        super(new URL[0], parent);
        this.pluginManager = pluginManager;
        this.pluginDescriptor = pluginDescriptor;
        this.parentFirst = parentFirst;
    }

    @Override
    public void addURL(URL url) {
        log.debug("Add '{}'", (Object)url);
        super.addURL(url);
    }

    public void addFile(File file) {
        try {
            this.addURL(file.getCanonicalFile().toURI().toURL());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            if (className.startsWith(JAVA_PACKAGE_PREFIX)) {
                return this.findSystemClass(className);
            }
            if (className.startsWith(PLUGIN_PACKAGE_PREFIX) && !className.startsWith("org.pf4j.demo")) {
                return this.getParent().loadClass(className);
            }
            log.trace("Received request to load class '{}'", (Object)className);
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                log.trace("Found loaded class '{}'", (Object)className);
                return loadedClass;
            }
            if (!this.parentFirst) {
                try {
                    loadedClass = this.findClass(className);
                    log.trace("Found class '{}' in plugin classpath", (Object)className);
                    return loadedClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    loadedClass = this.loadClassFromDependencies(className);
                    if (loadedClass != null) {
                        log.trace("Found class '{}' in dependencies", (Object)className);
                        return loadedClass;
                    }
                    log.trace("Couldn't find class '{}' in plugin classpath. Delegating to parent", (Object)className);
                    return super.loadClass(className);
                }
            }
            try {
                return super.loadClass(className);
            }
            catch (ClassCastException classCastException) {
                log.trace("Couldn't find class '{}' in parent. Delegating to plugin classpath", (Object)className);
                try {
                    loadedClass = this.findClass(className);
                    log.trace("Found class '{}' in plugin classpath", (Object)className);
                    return loadedClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    loadedClass = this.loadClassFromDependencies(className);
                    if (loadedClass != null) {
                        log.trace("Found class '{}' in dependencies", (Object)className);
                        return loadedClass;
                    }
                    throw new ClassNotFoundException(className);
                }
            }
        }
    }

    @Override
    public URL getResource(String name) {
        log.trace("Received request to load resource '{}'", (Object)name);
        if (!this.parentFirst) {
            URL url = this.findResource(name);
            if (url != null) {
                log.trace("Found resource '{}' in plugin classpath", (Object)name);
                return url;
            }
            log.trace("Couldn't find resource '{}' in plugin classpath. Delegating to parent", (Object)name);
            return super.getResource(name);
        }
        URL url = super.getResource(name);
        if (url != null) {
            log.trace("Found resource '{}' in parent", (Object)name);
            return url;
        }
        log.trace("Couldn't find resource '{}' in parent", (Object)name);
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.parentFirst) {
            ArrayList<URL> resources = new ArrayList<URL>();
            resources.addAll(Collections.list(this.findResources(name)));
            if (this.getParent() != null) {
                resources.addAll(Collections.list(this.getParent().getResources(name)));
            }
            return Collections.enumeration(resources);
        }
        return super.getResources(name);
    }

    private Class<?> loadClassFromDependencies(String className) {
        log.trace("Search in dependencies for class '{}'", (Object)className);
        List<PluginDependency> dependencies = this.pluginDescriptor.getDependencies();
        for (PluginDependency dependency : dependencies) {
            ClassLoader classLoader = this.pluginManager.getPluginClassLoader(dependency.getPluginId());
            if (classLoader == null && dependency.isOptional()) continue;
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

