/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pf4j.PluginRepository;
import org.pf4j.PluginRuntimeException;
import org.pf4j.util.FileUtils;

public class BasePluginRepository
implements PluginRepository {
    protected final Path pluginsRoot;
    protected FileFilter filter;
    protected Comparator<File> comparator;

    public BasePluginRepository(Path pluginsRoot) {
        this(pluginsRoot, null);
    }

    public BasePluginRepository(Path pluginsRoot, FileFilter filter) {
        this.pluginsRoot = pluginsRoot;
        this.filter = filter;
        this.comparator = (o1, o2) -> (int)(o2.lastModified() - o1.lastModified());
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setComparator(Comparator<File> comparator) {
        this.comparator = comparator;
    }

    @Override
    public List<Path> getPluginPaths() {
        File[] files = this.pluginsRoot.toFile().listFiles(this.filter);
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        if (this.comparator != null) {
            Arrays.sort(files, this.comparator);
        }
        ArrayList<Path> paths = new ArrayList<Path>(files.length);
        for (File file : files) {
            paths.add(file.toPath());
        }
        return paths;
    }

    @Override
    public boolean deletePluginPath(Path pluginPath) {
        if (!this.filter.accept(pluginPath.toFile())) {
            return false;
        }
        try {
            FileUtils.delete(pluginPath);
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
        catch (IOException e) {
            throw new PluginRuntimeException(e);
        }
    }
}

