/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.msadlds;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.LDAPOperationDecorator;
import org.keycloak.storage.ldap.mappers.PasswordUpdateCallback;

public class MSADLDSUserAccountControlStorageMapper
extends AbstractLDAPStorageMapper
implements PasswordUpdateCallback {
    private static final Logger logger = Logger.getLogger(MSADLDSUserAccountControlStorageMapper.class);
    private static final Pattern AUTH_EXCEPTION_REGEX = Pattern.compile(".*AcceptSecurityContext error, data ([0-9a-f]*), v.*");
    private static final Pattern AUTH_INVALID_NEW_PASSWORD = Pattern.compile("(?s).*problem 1005 \\(CONSTRAINT_ATT_TYPE\\), data [0-9a-f]*, Att 23 \\(userPassword\\).*");

    public MSADLDSUserAccountControlStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
        ldapProvider.setUpdater(this);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        query.addReturningLdapAttribute("pwdLastSet");
        query.addReturningLdapAttribute("msDS-UserAccountDisabled");
        query.addReturningReadOnlyLdapAttribute("pwdLastSet");
        if (this.ldapProvider.getEditMode() != UserStorageProvider.EditMode.WRITABLE) {
            query.addReturningReadOnlyLdapAttribute("msDS-UserAccountDisabled");
        }
    }

    @Override
    public LDAPOperationDecorator beforePasswordUpdate(UserModel user, LDAPObject ldapUser, UserCredentialModel password) {
        return null;
    }

    @Override
    public void passwordUpdated(UserModel user, LDAPObject ldapUser, UserCredentialModel password) {
        logger.debugf("Going to update pwdLastSet for ldap user '%s' after successful password update", (Object)ldapUser.getDn().toString());
        ldapUser.removeReadOnlyAttributeName("pwdLastSet");
        ldapUser.setSingleAttribute("pwdLastSet", "-1");
        if (user.isEnabled()) {
            ldapUser.setSingleAttribute("msDS-UserAccountDisabled", "FALSE");
            logger.debugf("Removing msDS-UserPasswordExpired of user '%s'", (Object)ldapUser.getDn().toString());
        }
        this.ldapProvider.getLdapIdentityStore().update(ldapUser);
    }

    @Override
    public void passwordUpdateFailed(UserModel user, LDAPObject ldapUser, UserCredentialModel password, ModelException exception) {
        throw this.processFailedPasswordUpdateException(exception);
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        return new MSADUserModelDelegate(delegate, ldapUser);
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
    }

    @Override
    public boolean onAuthenticationFailure(LDAPObject ldapUser, UserModel user, AuthenticationException ldapException, RealmModel realm) {
        String exceptionMessage = ldapException.getMessage();
        Matcher m = AUTH_EXCEPTION_REGEX.matcher(exceptionMessage);
        if (m.matches()) {
            String errorCode = m.group(1);
            return this.processAuthErrorCode(errorCode, user);
        }
        return false;
    }

    protected boolean processAuthErrorCode(String errorCode, UserModel user) {
        logger.debugf("MSAD LDS Error code is '%s' after failed LDAP login of user '%s'", (Object)errorCode, (Object)user.getUsername());
        if (this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE) {
            if (errorCode.equals("532") || errorCode.equals("773")) {
                if (!user.getRequiredActions().contains(UserModel.RequiredAction.UPDATE_PASSWORD.name())) {
                    user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                }
                return true;
            }
            if (errorCode.equals("533")) {
                if (user.isEnabled()) {
                    user.setEnabled(false);
                }
                return true;
            }
            if (errorCode.equals("775")) {
                logger.warnf("Locked user '%s' attempt to login", (Object)user.getUsername());
            }
        }
        return false;
    }

    protected ModelException processFailedPasswordUpdateException(ModelException e) {
        if (e.getCause() == null || e.getCause().getMessage() == null) {
            return e;
        }
        String exceptionMessage = e.getCause().getMessage();
        Matcher m = AUTH_INVALID_NEW_PASSWORD.matcher(exceptionMessage);
        if (m.matches()) {
            ModelException me = new ModelException("invalidPasswordRegexPatternMessage", (Throwable)e);
            me.setParameters(new Object[]{"passwordConstraintViolation"});
            return me;
        }
        return e;
    }

    public class MSADUserModelDelegate
    extends UserModelDelegate {
        private final LDAPObject ldapUser;

        public MSADUserModelDelegate(UserModel delegate, LDAPObject ldapUser) {
            super(delegate);
            this.ldapUser = ldapUser;
        }

        public boolean isEnabled() {
            boolean kcEnabled = super.isEnabled();
            if (this.getPwdLastSet() > 0L) {
                return kcEnabled && !Boolean.parseBoolean(this.ldapUser.getAttributeAsString("msDS-UserAccountDisabled"));
            }
            return kcEnabled;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (MSADLDSUserAccountControlStorageMapper.this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && this.getPwdLastSet() > 0L) {
                if (enabled) {
                    logger.debugf("Removing msDS-UserAccountDisabled of user '%s'", (Object)this.ldapUser.getDn().toString());
                    this.ldapUser.setSingleAttribute("msDS-UserAccountDisabled", "FALSE");
                } else {
                    logger.debugf("Setting msDS-UserAccountDisabled of user '%s' to value 'TRUE'", (Object)this.ldapUser.getDn().toString());
                    this.ldapUser.setSingleAttribute("msDS-UserAccountDisabled", "TRUE");
                }
                MSADLDSUserAccountControlStorageMapper.this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
            }
        }

        public void addRequiredAction(UserModel.RequiredAction action) {
            String actionName = action.name();
            this.addRequiredAction(actionName);
        }

        public void addRequiredAction(String action) {
            super.addRequiredAction(action);
            if (MSADLDSUserAccountControlStorageMapper.this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && UserModel.RequiredAction.UPDATE_PASSWORD.toString().equals(action)) {
                logger.debugf("Going to propagate required action UPDATE_PASSWORD to MSAD for ldap user '%s' ", (Object)this.ldapUser.getDn().toString());
                this.ldapUser.removeReadOnlyAttributeName("pwdLastSet");
                this.ldapUser.setSingleAttribute("pwdLastSet", "0");
                MSADLDSUserAccountControlStorageMapper.this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
            }
        }

        public void removeRequiredAction(UserModel.RequiredAction action) {
            String actionName = action.name();
            this.removeRequiredAction(actionName);
        }

        public void removeRequiredAction(String action) {
            super.removeRequiredAction(action);
            if (MSADLDSUserAccountControlStorageMapper.this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && UserModel.RequiredAction.UPDATE_PASSWORD.toString().equals(action) && !Boolean.parseBoolean(this.ldapUser.getAttributeAsString("msDS-UserPasswordNotRequired"))) {
                logger.debugf("Going to remove required action UPDATE_PASSWORD from MSAD LDS for ldap user '%s' ", (Object)this.ldapUser.getDn().toString());
                this.ldapUser.removeReadOnlyAttributeName("pwdLastSet");
                this.ldapUser.setSingleAttribute("pwdLastSet", "-1");
                MSADLDSUserAccountControlStorageMapper.this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
            }
        }

        public Set<String> getRequiredActions() {
            HashSet<String> requiredActions = super.getRequiredActions();
            if (MSADLDSUserAccountControlStorageMapper.this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && (this.getPwdLastSet() == 0L || Boolean.parseBoolean(this.ldapUser.getAttributeAsString("msDS-UserPasswordExpired")))) {
                requiredActions = new HashSet<String>(requiredActions);
                requiredActions.add(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
                return requiredActions;
            }
            return requiredActions;
        }

        protected long getPwdLastSet() {
            String pwdLastSet = this.ldapUser.getAttributeAsString("pwdLastSet");
            return pwdLastSet == null ? 0L : Long.parseLong(pwdLastSet);
        }
    }
}

