/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import org.apiguardian.api.API;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.execution.RunListenerAdapter;
import org.junit.vintage.engine.execution.TestRun;

@API(status=API.Status.INTERNAL, since="4.12")
public class RunnerExecutor {
    private final EngineExecutionListener engineExecutionListener;

    public RunnerExecutor(EngineExecutionListener engineExecutionListener) {
        this.engineExecutionListener = engineExecutionListener;
    }

    public void execute(RunnerTestDescriptor runnerTestDescriptor) {
        TestRun testRun = new TestRun(runnerTestDescriptor);
        JUnitCore core = new JUnitCore();
        core.addListener((RunListener)new RunListenerAdapter(testRun, this.engineExecutionListener));
        try {
            core.run(runnerTestDescriptor.toRequest());
        }
        catch (Throwable t) {
            this.reportUnexpectedFailure(testRun, runnerTestDescriptor, TestExecutionResult.failed((Throwable)t));
        }
    }

    private void reportUnexpectedFailure(TestRun testRun, RunnerTestDescriptor runnerTestDescriptor, TestExecutionResult result) {
        if (testRun.isNotStarted((TestDescriptor)runnerTestDescriptor)) {
            this.engineExecutionListener.executionStarted((TestDescriptor)runnerTestDescriptor);
        }
        this.engineExecutionListener.executionFinished((TestDescriptor)runnerTestDescriptor, result);
    }
}

