/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec;

import org.jetlinks.core.utils.BytesUtils;

public enum Endian {
    BIG{

        @Override
        public long decode(byte[] payload, int offset, int length) {
            return BytesUtils.beToLong((byte[])payload, (int)offset, (int)length);
        }

        @Override
        public void encode(long value, byte[] payload, int offset, int length) {
            BytesUtils.numberToBe((byte[])payload, (Number)value, (int)offset, (int)length);
        }
    }
    ,
    Little{

        @Override
        public long decode(byte[] payload, int offset, int length) {
            return BytesUtils.leToLong((byte[])payload, (int)offset, (int)length);
        }

        @Override
        public void encode(long value, byte[] payload, int offset, int length) {
            BytesUtils.numberToLe((byte[])payload, (Number)value, (int)offset, (int)length);
        }
    };


    public abstract long decode(byte[] var1, int var2, int var3);

    public abstract void encode(long var1, byte[] var3, int var4, int var5);
}

