/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.types.FileType;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;
import org.springframework.http.MediaType;

public class JetLinksFileCodec
extends AbstractDataTypeCodec<FileType> {
    public String getTypeId() {
        return "file";
    }

    @Override
    public FileType decode(FileType type, Map<String, Object> config) {
        super.decode(type, config);
        Optional.ofNullable(config.get("bodyType")).map(String::valueOf).flatMap(FileType.BodyType::of).ifPresent(arg_0 -> ((FileType)type).setBodyType(arg_0));
        Optional.ofNullable(config.get("mediaType")).map(String::valueOf).map(MediaType::parseMediaType).ifPresent(arg_0 -> ((FileType)type).setMediaType(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, FileType type) {
        super.doEncode(encoded, type);
        encoded.put("bodyType", type.getBodyType().name());
        encoded.put("mediaType", type.getMediaType().toString());
    }
}

