/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.supports.official.JetLinksDataTypeCodecs;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksEnumCodec
extends AbstractDataTypeCodec<EnumType> {
    public String getTypeId() {
        return "enum";
    }

    @Override
    public EnumType decode(EnumType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        JSONArray arr = jsonObject.getJSONArray("elements");
        if (arr != null) {
            ArrayList<EnumType.Element> elements = new ArrayList<EnumType.Element>(arr.size());
            for (Object obj : arr) {
                if (obj instanceof Map) {
                    elements.add(EnumType.Element.of((Map)Maps.transformValues((Map)((Map)obj), String::valueOf)));
                    continue;
                }
                if (!(obj instanceof EnumType.Element)) continue;
                elements.add((EnumType.Element)obj);
            }
            type.setElements(elements);
        }
        Optional.ofNullable(jsonObject.get((Object)"valueType")).map(v -> {
            if (v instanceof Map) {
                return new JSONObject((Map)v);
            }
            JSONObject eleType = new JSONObject();
            eleType.put("type", v);
            return eleType;
        }).map(eleType -> {
            DataType dataType = (DataType)DataTypes.lookup((String)eleType.getString("type")).get();
            JetLinksDataTypeCodecs.getCodec(dataType.getId()).ifPresent(codec -> codec.decode(dataType, (Map)eleType));
            return dataType;
        }).ifPresent(arg_0 -> ((EnumType)type).setValueType(arg_0));
        type.setMulti(jsonObject.getBooleanValue("multi"));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, EnumType type) {
        super.doEncode(encoded, type);
        if (type.getElements() == null) {
            return;
        }
        encoded.put("elements", type.getElements().stream().map(EnumType.Element::toMap).collect(Collectors.toList()));
        encoded.put("valueType", JetLinksDataTypeCodecs.encode(type.getValueType()).orElse(null));
        encoded.put("multi", type.isMulti());
    }
}

