/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.redis;

import java.util.Collection;
import org.jetlinks.core.cluster.ClusterSet;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveSetOperations;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisClusterSet<V>
implements ClusterSet<V> {
    private final ReactiveSetOperations<Object, Object> set;
    private final String redisKey;

    public RedisClusterSet(String redisKey, ReactiveRedisOperations<Object, Object> redis) {
        this(redisKey, (ReactiveSetOperations<Object, Object>)redis.opsForSet());
    }

    private RedisClusterSet(String redisKey, ReactiveSetOperations<Object, Object> set) {
        this.set = set;
        this.redisKey = redisKey;
    }

    public Mono<Boolean> add(V value) {
        return this.set.add((Object)this.redisKey, new Object[]{value}).thenReturn((Object)true);
    }

    public Mono<Boolean> add(Collection<V> values) {
        return this.set.add((Object)this.redisKey, values.toArray()).thenReturn((Object)true);
    }

    public Mono<Boolean> remove(V value) {
        return this.set.remove((Object)this.redisKey, new Object[]{value}).thenReturn((Object)true);
    }

    public Mono<Boolean> remove(Collection<V> values) {
        return this.set.remove((Object)this.redisKey, values.toArray()).thenReturn((Object)true);
    }

    public Flux<V> values() {
        return this.set.members((Object)this.redisKey).mapNotNull(v -> v);
    }
}

