/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperator;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrDynamicOperatorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.AccessorPropertyLValue;
import org.jetbrains.kotlin.psi2ir.intermediate.ArrayAccessAssignmentReceiver;
import org.jetbrains.kotlin.psi2ir.intermediate.AssignmentReceiver;
import org.jetbrains.kotlin.psi2ir.intermediate.BackingFieldLValue;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.CallReceiver;
import org.jetbrains.kotlin.psi2ir.intermediate.DelegatedLocalPropertyLValue;
import org.jetbrains.kotlin.psi2ir.intermediate.DynamicMemberLValue;
import org.jetbrains.kotlin.psi2ir.intermediate.FieldPropertyLValue;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.LValue;
import org.jetbrains.kotlin.psi2ir.intermediate.OnceExpressionValue;
import org.jetbrains.kotlin.psi2ir.intermediate.PropertyLValueBase;
import org.jetbrains.kotlin.psi2ir.intermediate.RematerializableValue;
import org.jetbrains.kotlin.psi2ir.intermediate.SpecialExpressionAssignmentReceiver;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002JJ\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\"J\"\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010%\u001a\u00020&H\u0002J4\u0010'\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\b2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010*\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000eJ \u0010+\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010,\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020-2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010.\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0018H\u0002J\u001c\u00105\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0002J\f\u00106\u001a\u00020\n*\u00020\nH\u0002\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/AssignmentGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "createBackingFieldLValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/BackingFieldLValue;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "receiverValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "createPropertyLValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/PropertyLValueBase;", "propertyReceiver", "Lorg/jetbrains/kotlin/psi2ir/intermediate/CallReceiver;", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "superQualifier", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createVariableValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/VariableLValue;", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "generateArrayAccessAssignmentReceiver", "Lorg/jetbrains/kotlin/psi2ir/intermediate/ArrayAccessAssignmentReceiver;", "ktLeft", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "generateAssignment", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "generateAssignmentReceiver", "Lorg/jetbrains/kotlin/psi2ir/intermediate/AssignmentReceiver;", "isAssignmentStatement", "", "generateAssignmentReceiverForProperty", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "generateAugmentedAssignment", "generateExpressionAssignmentReceiver", "generatePostfixIncrementDecrement", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "generatePrefixIncrementDecrement", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "getDynamicAugmentedAssignmentOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperator;", "operatorToken", "Lcom/intellij/psi/tree/IElementType;", "getThisClass", "isValInitializationInConstructor", "unwrapPropertyDescriptor", "ir.psi2ir"})
public final class AssignmentGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generateAssignment(@NotNull KtBinaryExpression ktExpression) {
        Intrinsics.checkParameterIsNotNull((Object)ktExpression, (String)"ktExpression");
        KtExpression ktExpression2 = ktExpression.getLeft();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.left!!");
        KtExpression ktLeft = ktExpression2;
        KtExpression ktExpression3 = ktExpression.getRight();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ktExpression.right!!");
        IrExpression irRhs = this.genExpr(ktExpression3);
        AssignmentReceiver irAssignmentReceiver = AssignmentGenerator.generateAssignmentReceiver$default(this, ktLeft, IrStatementOrigin.EQ.INSTANCE, false, 4, null);
        return irAssignmentReceiver.assign(irRhs);
    }

    @NotNull
    public final IrExpression generateAugmentedAssignment(@NotNull KtBinaryExpression ktExpression, @NotNull IrStatementOrigin origin) {
        Intrinsics.checkParameterIsNotNull((Object)ktExpression, (String)"ktExpression");
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktExpression);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> opResolvedCall = resolvedCall2;
        WritableSlice<KtExpression, Boolean> writableSlice = BindingContext.VARIABLE_REASSIGNMENT;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.VARIABLE_REASSIGNMENT");
        Boolean bl = (Boolean)GeneratorKt.get(this, writableSlice, ktExpression);
        boolean isSimpleAssignment = bl != null ? bl : false;
        KtExpression ktExpression2 = ktExpression.getLeft();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.left!!");
        KtExpression ktLeft = ktExpression2;
        KtExpression ktExpression3 = ktExpression.getRight();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ktExpression.right!!");
        KtExpression ktRight = ktExpression3;
        AssignmentReceiver irAssignmentReceiver = AssignmentGenerator.generateAssignmentReceiver$default(this, ktLeft, origin, false, 4, null);
        boolean isDynamicCall = DynamicCallsKt.isDynamic(opResolvedCall.getResultingDescriptor());
        return irAssignmentReceiver.assign((Function1<? super LValue, ? extends IrExpression>)((Function1)new Function1<LValue, IrExpression>(this, isDynamicCall, ktExpression, ktRight, opResolvedCall, origin, isSimpleAssignment){
            final /* synthetic */ AssignmentGenerator this$0;
            final /* synthetic */ boolean $isDynamicCall;
            final /* synthetic */ KtBinaryExpression $ktExpression;
            final /* synthetic */ KtExpression $ktRight;
            final /* synthetic */ ResolvedCall $opResolvedCall;
            final /* synthetic */ IrStatementOrigin $origin;
            final /* synthetic */ boolean $isSimpleAssignment;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrExpression invoke(@NotNull LValue irLValue) {
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)irLValue, (String)"irLValue");
                if (this.$isDynamicCall) {
                    int n = PsiUtilsKt.getStartOffsetSkippingComments(this.$ktExpression);
                    int n2 = PsiUtilsKt.getEndOffset(this.$ktExpression);
                    IrType irType = this.this$0.getContext().getIrBuiltIns().getUnitType();
                    IElementType iElementType = this.$ktExpression.getOperationToken();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"ktExpression.operationToken");
                    IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl = new IrDynamicOperatorExpressionImpl(n, n2, irType, AssignmentGenerator.access$getDynamicAugmentedAssignmentOperator(this.this$0, iElementType));
                    boolean bl = false;
                    boolean bl2 = false;
                    IrDynamicOperatorExpressionImpl $this$apply = irDynamicOperatorExpressionImpl;
                    boolean bl3 = false;
                    IrDynamicExpressionKt.setLeft($this$apply, irLValue.load());
                    IrDynamicExpressionKt.setRight($this$apply, this.this$0.genExpr(this.$ktRight));
                    object = irDynamicOperatorExpressionImpl;
                } else {
                    void var3_5;
                    CallBuilder opCall = ArgumentsGenerationUtilsKt.pregenerateCallReceivers(this.this$0.getStatementGenerator(), this.$opResolvedCall);
                    CallBuilderKt.setExplicitReceiverValue(opCall, irLValue);
                    opCall.getIrValueArgumentsByIndex()[0] = this.this$0.genExpr(this.$ktRight);
                    ArgumentsGenerationUtilsKt.generateSamConversionForValueArgumentsIfRequired(this.this$0.getStatementGenerator(), opCall, this.$opResolvedCall.getResultingDescriptor());
                    IrExpression irOpCall = CallGeneratorKt.generateCall(new CallGenerator(this.this$0.getStatementGenerator()), this.$ktExpression, opCall, this.$origin);
                    object = this.$isSimpleAssignment ? irLValue.store(irOpCall) : var3_5;
                }
                return object;
            }
            {
                this.this$0 = assignmentGenerator;
                this.$isDynamicCall = bl;
                this.$ktExpression = ktBinaryExpression;
                this.$ktRight = ktExpression;
                this.$opResolvedCall = resolvedCall2;
                this.$origin = irStatementOrigin;
                this.$isSimpleAssignment = bl2;
                super(1);
            }
        }));
    }

    private final IrDynamicOperator getDynamicAugmentedAssignmentOperator(IElementType operatorToken) {
        IrDynamicOperator irDynamicOperator;
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
            irDynamicOperator = IrDynamicOperator.PLUSEQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
            irDynamicOperator = IrDynamicOperator.MINUSEQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
            irDynamicOperator = IrDynamicOperator.MULEQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
            irDynamicOperator = IrDynamicOperator.DIVEQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
            irDynamicOperator = IrDynamicOperator.MODEQ;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected operator token: " + operatorToken)));
        }
        return irDynamicOperator;
    }

    @NotNull
    public final IrExpression generatePrefixIncrementDecrement(@NotNull KtPrefixExpression ktExpression, @NotNull IrStatementOrigin origin) {
        Intrinsics.checkParameterIsNotNull((Object)ktExpression, (String)"ktExpression");
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktExpression);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> opResolvedCall = resolvedCall2;
        KtExpression ktExpression2 = ktExpression.getBaseExpression();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.baseExpression!!");
        KtExpression ktBaseExpression = ktExpression2;
        AssignmentReceiver irAssignmentReceiver = this.generateAssignmentReceiver(ktBaseExpression, origin, false);
        boolean isDynamicCall = DynamicCallsKt.isDynamic(opResolvedCall.getResultingDescriptor());
        return irAssignmentReceiver.assign((Function1<? super LValue, ? extends IrExpression>)((Function1)new Function1<LValue, IrExpression>(this, ktExpression, isDynamicCall, origin, opResolvedCall){
            final /* synthetic */ AssignmentGenerator this$0;
            final /* synthetic */ KtPrefixExpression $ktExpression;
            final /* synthetic */ boolean $isDynamicCall;
            final /* synthetic */ IrStatementOrigin $origin;
            final /* synthetic */ ResolvedCall $opResolvedCall;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrExpression invoke(@NotNull LValue irLValue) {
                IrExpression irExpression;
                Intrinsics.checkParameterIsNotNull((Object)irLValue, (String)"irLValue");
                int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(this.$ktExpression);
                int endOffset = PsiUtilsKt.getEndOffset(this.$ktExpression);
                if (this.$isDynamicCall) {
                    IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl = new IrDynamicOperatorExpressionImpl(startOffset, endOffset, irLValue.getType(), Intrinsics.areEqual((Object)this.$ktExpression.getOperationToken(), (Object)KtTokens.PLUSPLUS) ? IrDynamicOperator.PREFIX_INCREMENT : IrDynamicOperator.PREFIX_DECREMENT);
                    boolean bl = false;
                    boolean bl2 = false;
                    IrDynamicOperatorExpressionImpl $this$apply = irDynamicOperatorExpressionImpl;
                    boolean bl3 = false;
                    $this$apply.setReceiver(irLValue.load());
                    irExpression = irDynamicOperatorExpressionImpl;
                } else {
                    void origin$iv;
                    void $this$irBlock$iv;
                    AssignmentGenerator assignmentGenerator = this.this$0;
                    IrStatementOrigin irStatementOrigin = this.$origin;
                    IrType resultType$iv = irLValue.getType();
                    boolean $i$f$irBlock = false;
                    IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset, endOffset, (IrStatementOrigin)origin$iv, resultType$iv, false, 64, null);
                    boolean $i$f$block = false;
                    IrBlockBuilder $this$irBlock = this_$iv$iv;
                    boolean bl = false;
                    CallBuilder opCall = ArgumentsGenerationUtilsKt.pregenerateCall(this.this$0.getStatementGenerator(), this.$opResolvedCall);
                    CallBuilderKt.setExplicitReceiverValue(opCall, irLValue);
                    IrExpression irOpCall = CallGeneratorKt.generateCall(new CallGenerator(this.this$0.getStatementGenerator()), this.$ktExpression, opCall, this.$origin);
                    $this$irBlock.unaryPlus(irLValue.store(irOpCall));
                    $this$irBlock.unaryPlus(irLValue.load());
                    irExpression = this_$iv$iv.doBuild();
                }
                return irExpression;
            }
            {
                this.this$0 = assignmentGenerator;
                this.$ktExpression = ktPrefixExpression;
                this.$isDynamicCall = bl;
                this.$origin = irStatementOrigin;
                this.$opResolvedCall = resolvedCall2;
                super(1);
            }
        }));
    }

    @NotNull
    public final IrExpression generatePostfixIncrementDecrement(@NotNull KtPostfixExpression ktExpression, @NotNull IrStatementOrigin origin) {
        Intrinsics.checkParameterIsNotNull((Object)ktExpression, (String)"ktExpression");
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktExpression);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> opResolvedCall = resolvedCall2;
        KtExpression ktExpression2 = ktExpression.getBaseExpression();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.baseExpression!!");
        KtExpression ktBaseExpression = ktExpression2;
        AssignmentReceiver irAssignmentReceiver = this.generateAssignmentReceiver(ktBaseExpression, origin, false);
        boolean isDynamicCall = DynamicCallsKt.isDynamic(opResolvedCall.getResultingDescriptor());
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktExpression);
        int endOffset = PsiUtilsKt.getEndOffset(ktExpression);
        return irAssignmentReceiver.assign((Function1<? super LValue, ? extends IrExpression>)((Function1)new Function1<LValue, IrExpression>(this, isDynamicCall, startOffset, endOffset, ktExpression, origin, opResolvedCall){
            final /* synthetic */ AssignmentGenerator this$0;
            final /* synthetic */ boolean $isDynamicCall;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ KtPostfixExpression $ktExpression;
            final /* synthetic */ IrStatementOrigin $origin;
            final /* synthetic */ ResolvedCall $opResolvedCall;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IrExpression invoke(@NotNull LValue irLValue) {
                IrExpression irExpression;
                Intrinsics.checkParameterIsNotNull((Object)irLValue, (String)"irLValue");
                if (this.$isDynamicCall) {
                    IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl = new IrDynamicOperatorExpressionImpl(this.$startOffset, this.$endOffset, irLValue.getType(), Intrinsics.areEqual((Object)this.$ktExpression.getOperationToken(), (Object)KtTokens.PLUSPLUS) ? IrDynamicOperator.POSTFIX_INCREMENT : IrDynamicOperator.POSTFIX_DECREMENT);
                    boolean bl = false;
                    boolean bl2 = false;
                    IrDynamicOperatorExpressionImpl $this$apply = irDynamicOperatorExpressionImpl;
                    boolean bl3 = false;
                    $this$apply.setReceiver(irLValue.load());
                    irExpression = irDynamicOperatorExpressionImpl;
                } else {
                    void origin$iv;
                    void endOffset$iv;
                    void startOffset$iv;
                    void $this$irBlock$iv;
                    AssignmentGenerator assignmentGenerator = this.this$0;
                    int n = this.$startOffset;
                    int n2 = this.$endOffset;
                    IrStatementOrigin $this$apply = this.$origin;
                    IrType resultType$iv = irLValue.getType();
                    boolean $i$f$irBlock = false;
                    IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, (IrStatementOrigin)origin$iv, resultType$iv, false, 64, null);
                    boolean $i$f$block = false;
                    IrBlockBuilder $this$irBlock = this_$iv$iv;
                    boolean bl = false;
                    IrVariable temporary = ExpressionHelpersKt.irTemporary$default($this$irBlock, irLValue.load(), null, null, null, 14, null);
                    CallBuilder opCall = ArgumentsGenerationUtilsKt.pregenerateCall(this.this$0.getStatementGenerator(), this.$opResolvedCall);
                    CallBuilderKt.setExplicitReceiverValue(opCall, new VariableLValue($this$irBlock.getContext(), this.$startOffset, this.$endOffset, (IrValueSymbol)temporary.getSymbol(), temporary.getType(), null, 32, null));
                    IrExpression irOpCall = CallGeneratorKt.generateCall(new CallGenerator(this.this$0.getStatementGenerator()), this.$ktExpression, opCall, this.$origin);
                    $this$irBlock.unaryPlus(irLValue.store(irOpCall));
                    $this$irBlock.unaryPlus(ExpressionHelpersKt.irGet($this$irBlock, temporary.getType(), temporary.getSymbol()));
                    irExpression = this_$iv$iv.doBuild();
                }
                return irExpression;
            }
            {
                this.this$0 = assignmentGenerator;
                this.$isDynamicCall = bl;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$ktExpression = ktPostfixExpression;
                this.$origin = irStatementOrigin;
                this.$opResolvedCall = resolvedCall2;
                super(1);
            }
        }));
    }

    private final AssignmentReceiver generateAssignmentReceiver(KtExpression ktLeft, IrStatementOrigin origin, boolean isAssignmentStatement) {
        AssignmentReceiver assignmentReceiver;
        if (ktLeft instanceof KtArrayAccessExpression) {
            return this.generateArrayAccessAssignmentReceiver((KtArrayAccessExpression)ktLeft, origin);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktLeft);
        if (resolvedCall2 == null) {
            return this.generateExpressionAssignmentReceiver(ktLeft, origin, isAssignmentStatement);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktLeft);
        int endOffset = PsiUtilsKt.getEndOffset(ktLeft);
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof SyntheticFieldDescriptor) {
            IntermediateValue receiverValue = ArgumentsGenerationUtilsKt.generateBackingFieldReceiver(this.getStatementGenerator(), startOffset, endOffset, resolvedCall3, (SyntheticFieldDescriptor)descriptor2);
            assignmentReceiver = this.createBackingFieldLValue(ktLeft, ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor(), receiverValue, origin);
        } else if (callableDescriptor instanceof LocalVariableDescriptor) {
            AssignmentReceiver assignmentReceiver2;
            if (((LocalVariableDescriptor)descriptor2).isDelegated()) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol3;
                LocalVariableAccessorDescriptor it;
                boolean bl;
                boolean bl2;
                IrGeneratorContext irGeneratorContext;
                int n;
                int n2;
                IrType irType;
                LocalVariableAccessorDescriptor localVariableAccessorDescriptor;
                IrGeneratorContext irGeneratorContext2 = this.getContext();
                int n3 = startOffset;
                int n4 = endOffset;
                KotlinType kotlinType2 = ((LocalVariableDescriptor)descriptor2).getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.type");
                IrType irType2 = this.toIrType(kotlinType2);
                LocalVariableAccessorDescriptor.Getter getter2 = ((LocalVariableDescriptor)descriptor2).getGetter();
                if (getter2 != null) {
                    localVariableAccessorDescriptor = getter2;
                    irType = irType2;
                    n2 = n4;
                    n = n3;
                    irGeneratorContext = irGeneratorContext2;
                    bl2 = false;
                    bl = false;
                    it = localVariableAccessorDescriptor;
                    boolean bl3 = false;
                    SymbolTable symbolTable = this.getContext().getSymbolTable();
                    LocalVariableAccessorDescriptor localVariableAccessorDescriptor2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localVariableAccessorDescriptor2, (String)"it");
                    irSimpleFunctionSymbol3 = symbolTable.referenceDeclaredFunction(localVariableAccessorDescriptor2);
                    irGeneratorContext2 = irGeneratorContext;
                    n3 = n;
                    n4 = n2;
                    irType2 = irType;
                    irSimpleFunctionSymbol2 = irSimpleFunctionSymbol3;
                } else {
                    irSimpleFunctionSymbol2 = null;
                }
                LocalVariableAccessorDescriptor.Setter setter2 = ((LocalVariableDescriptor)descriptor2).getSetter();
                if (setter2 != null) {
                    localVariableAccessorDescriptor = setter2;
                    irSimpleFunctionSymbol3 = irSimpleFunctionSymbol2;
                    irType = irType2;
                    n2 = n4;
                    n = n3;
                    irGeneratorContext = irGeneratorContext2;
                    bl2 = false;
                    bl = false;
                    it = localVariableAccessorDescriptor;
                    boolean bl4 = false;
                    SymbolTable symbolTable = this.getContext().getSymbolTable();
                    LocalVariableAccessorDescriptor localVariableAccessorDescriptor3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localVariableAccessorDescriptor3, (String)"it");
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = symbolTable.referenceDeclaredFunction(localVariableAccessorDescriptor3);
                    irGeneratorContext2 = irGeneratorContext;
                    n3 = n;
                    n4 = n2;
                    irType2 = irType;
                    irSimpleFunctionSymbol2 = irSimpleFunctionSymbol3;
                    irSimpleFunctionSymbol = irSimpleFunctionSymbol4;
                } else {
                    irSimpleFunctionSymbol = null;
                }
                IrStatementOrigin irStatementOrigin = origin;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol5 = irSimpleFunctionSymbol;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol6 = irSimpleFunctionSymbol2;
                IrType irType3 = irType2;
                int n5 = n4;
                int n6 = n3;
                IrGeneratorContext irGeneratorContext3 = irGeneratorContext2;
                assignmentReceiver2 = new DelegatedLocalPropertyLValue(irGeneratorContext3, n6, n5, irType3, irSimpleFunctionSymbol6, irSimpleFunctionSymbol5, irStatementOrigin);
            } else {
                assignmentReceiver2 = this.createVariableValue(ktLeft, (ValueDescriptor)descriptor2, origin);
            }
            assignmentReceiver = assignmentReceiver2;
        } else {
            assignmentReceiver = callableDescriptor instanceof PropertyDescriptor ? this.generateAssignmentReceiverForProperty((PropertyDescriptor)descriptor2, origin, ktLeft, resolvedCall3, isAssignmentStatement) : (callableDescriptor instanceof ValueDescriptor ? (AssignmentReceiver)this.createVariableValue(ktLeft, (ValueDescriptor)descriptor2, origin) : (AssignmentReceiver)new OnceExpressionValue(this.genExpr(ktLeft)));
        }
        return assignmentReceiver;
    }

    static /* synthetic */ AssignmentReceiver generateAssignmentReceiver$default(AssignmentGenerator assignmentGenerator, KtExpression ktExpression, IrStatementOrigin irStatementOrigin, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return assignmentGenerator.generateAssignmentReceiver(ktExpression, irStatementOrigin, bl);
    }

    private final AssignmentReceiver generateExpressionAssignmentReceiver(KtExpression ktLeft, IrStatementOrigin origin, boolean isAssignmentStatement) {
        if (!isAssignmentStatement) {
            StringBuilder stringBuilder = new StringBuilder().append("Arbitrary assignment receiver found in assignment-like expression: ");
            PsiElement psiElement = ktLeft.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"ktLeft.parent");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(psiElement.getText()).toString()));
        }
        KotlinTypeMarker kotlinTypeMarker = this.getContext().getBindingContext().getType(ktLeft);
        if (kotlinTypeMarker == null || (kotlinTypeMarker = this.toIrType((KotlinType)kotlinTypeMarker)) == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No type for expression " + ktLeft.getText())));
        }
        return new SpecialExpressionAssignmentReceiver(this.getStatementGenerator(), ktLeft, origin, (IrType)kotlinTypeMarker);
    }

    private final VariableLValue createVariableValue(KtExpression ktExpression, ValueDescriptor descriptor2, IrStatementOrigin origin) {
        IrGeneratorContext irGeneratorContext = this.getContext();
        int n = PsiUtilsKt.getStartOffsetSkippingComments(ktExpression);
        int n2 = PsiUtilsKt.getEndOffset(ktExpression);
        IrValueSymbol irValueSymbol = this.getContext().getSymbolTable().referenceValue(descriptor2);
        KotlinType kotlinType2 = descriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.type");
        return new VariableLValue(irGeneratorContext, n, n2, irValueSymbol, this.toIrType(kotlinType2), origin);
    }

    private final BackingFieldLValue createBackingFieldLValue(KtExpression ktExpression, PropertyDescriptor descriptor2, IntermediateValue receiverValue, IrStatementOrigin origin) {
        IrGeneratorContext irGeneratorContext = this.getContext();
        int n = PsiUtilsKt.getStartOffsetSkippingComments(ktExpression);
        int n2 = PsiUtilsKt.getEndOffset(ktExpression);
        KotlinType kotlinType2 = descriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.type");
        return new BackingFieldLValue(irGeneratorContext, n, n2, this.toIrType(kotlinType2), this.getContext().getSymbolTable().referenceField(descriptor2), receiverValue, origin);
    }

    private final AssignmentReceiver generateAssignmentReceiverForProperty(PropertyDescriptor descriptor2, IrStatementOrigin origin, KtExpression ktLeft, ResolvedCall<?> resolvedCall2, boolean isAssignmentStatement) {
        AssignmentReceiver assignmentReceiver;
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            IrGeneratorContext irGeneratorContext = this.getContext();
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktLeft);
            int n2 = PsiUtilsKt.getEndOffset(ktLeft);
            KotlinType kotlinType2 = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.type");
            IrType irType = this.toIrType(kotlinType2);
            String string2 = descriptor2.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"descriptor.name.asString()");
            StatementGenerator statementGenerator = this.getStatementGenerator();
            KtElement ktElement = ktLeft;
            CallableDescriptor callableDescriptor = descriptor2;
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            ReceiverValue receiverValue2 = resolvedCall2.getExtensionReceiver();
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
            assignmentReceiver = new DynamicMemberLValue(irGeneratorContext, n, n2, irType, string2, ArgumentsGenerationUtilsKt.generateCallReceiver(statementGenerator, ktElement, callableDescriptor, receiverValue, receiverValue2, CallUtilKt.isSafeCall(call2), isAssignmentStatement));
        } else if (this.isValInitializationInConstructor(descriptor2, resolvedCall2)) {
            ClassDescriptor thisClass = this.getThisClass();
            ReceiverParameterDescriptor receiverParameterDescriptor = thisClass.getThisAsReceiverParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"thisClass.thisAsReceiverParameter");
            ReceiverParameterDescriptor thisAsReceiverParameter = receiverParameterDescriptor;
            KotlinType kotlinType3 = thisAsReceiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"thisAsReceiverParameter.type");
            IrType thisType = this.toIrType(kotlinType3);
            IrGetValueImpl irThis = new IrGetValueImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktLeft), PsiUtilsKt.getEndOffset(ktLeft), thisType, this.getContext().getSymbolTable().referenceValueParameter(thisAsReceiverParameter), null, 16, null);
            assignmentReceiver = this.createBackingFieldLValue(ktLeft, descriptor2, new RematerializableValue(irThis), null);
        } else {
            StatementGenerator statementGenerator = this.getStatementGenerator();
            KtElement ktElement = ktLeft;
            CallableDescriptor callableDescriptor = descriptor2;
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            ReceiverValue receiverValue3 = resolvedCall2.getExtensionReceiver();
            Call call3 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"resolvedCall.call");
            CallReceiver propertyReceiver = ArgumentsGenerationUtilsKt.generateCallReceiver(statementGenerator, ktElement, callableDescriptor, receiverValue, receiverValue3, CallUtilKt.isSafeCall(call3), isAssignmentStatement);
            ClassDescriptor superQualifier = ArgumentsGenerationUtilsKt.getSuperQualifier(this, resolvedCall2);
            assignmentReceiver = this.createPropertyLValue(ktLeft, descriptor2, propertyReceiver, ArgumentsGenerationUtilsKt.getTypeArguments(resolvedCall2), origin, superQualifier);
        }
        return assignmentReceiver;
    }

    private final PropertyDescriptor unwrapPropertyDescriptor(@NotNull PropertyDescriptor $this$unwrapPropertyDescriptor) {
        PropertyDescriptor propertyDescriptor2 = $this$unwrapPropertyDescriptor;
        return propertyDescriptor2 instanceof PropertyImportedFromObject ? (PropertyDescriptor)((PropertyImportedFromObject)$this$unwrapPropertyDescriptor).getCallableFromObject() : $this$unwrapPropertyDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyLValueBase createPropertyLValue(KtExpression ktExpression, PropertyDescriptor descriptor2, CallReceiver propertyReceiver, Map<TypeParameterDescriptor, ? extends KotlinType> typeArgumentsMap, IrStatementOrigin origin, ClassDescriptor superQualifier) {
        PropertyLValueBase propertyLValueBase;
        IrFunctionSymbol irFunctionSymbol;
        IrFunctionSymbol irFunctionSymbol2;
        boolean bl;
        IrClassSymbol irClassSymbol;
        ClassDescriptor classDescriptor2 = superQualifier;
        if (classDescriptor2 != null) {
            ClassDescriptor classDescriptor3 = classDescriptor2;
            boolean bl2 = false;
            boolean bl3 = false;
            ClassDescriptor it = classDescriptor3;
            boolean bl4 = false;
            irClassSymbol = this.getContext().getSymbolTable().referenceClass(it);
        } else {
            irClassSymbol = null;
        }
        IrClassSymbol superQualifierSymbol = irClassSymbol;
        PropertyDescriptor unwrappedPropertyDescriptor = this.unwrapPropertyDescriptor(descriptor2);
        FunctionDescriptor getterDescriptor = KotlinUtilsKt.getUnwrappedGetMethod(unwrappedPropertyDescriptor);
        FunctionDescriptor setterDescriptor = KotlinUtilsKt.getUnwrappedSetMethod(unwrappedPropertyDescriptor);
        FunctionDescriptor functionDescriptor = getterDescriptor;
        if (functionDescriptor != null) {
            FunctionDescriptor bl4 = functionDescriptor;
            boolean bl5 = false;
            bl = false;
            FunctionDescriptor it = bl4;
            boolean bl6 = false;
            ReferenceSymbolTable referenceSymbolTable = this.getContext().getSymbolTable();
            FunctionDescriptor functionDescriptor2 = it.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"it.original");
            irFunctionSymbol2 = IrUtilsKt.referenceFunction(referenceSymbolTable, functionDescriptor2);
        } else {
            irFunctionSymbol2 = null;
        }
        IrFunctionSymbol getterSymbol = irFunctionSymbol2;
        FunctionDescriptor functionDescriptor3 = setterDescriptor;
        if (functionDescriptor3 != null) {
            FunctionDescriptor functionDescriptor4 = functionDescriptor3;
            bl = false;
            boolean bl7 = false;
            FunctionDescriptor it = functionDescriptor4;
            boolean bl8 = false;
            ReferenceSymbolTable referenceSymbolTable = this.getContext().getSymbolTable();
            FunctionDescriptor functionDescriptor5 = it.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor5, (String)"it.original");
            irFunctionSymbol = IrUtilsKt.referenceFunction(referenceSymbolTable, functionDescriptor5);
        } else {
            irFunctionSymbol = null;
        }
        IrFunctionSymbol setterSymbol = irFunctionSymbol;
        KotlinType kotlinType2 = descriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.type");
        IrType propertyIrType = this.toIrType(kotlinType2);
        if (getterSymbol != null || setterSymbol != null) {
            List list2;
            Map<TypeParameterDescriptor, ? extends KotlinType> map2 = typeArgumentsMap;
            if (map2 != null) {
                void $this$mapTo$iv$iv;
                Map<TypeParameterDescriptor, ? extends KotlinType> map3 = map2;
                boolean bl9 = false;
                boolean bl10 = false;
                Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2 = map3;
                boolean bl11 = false;
                PropertyDescriptor propertyDescriptor2 = descriptor2.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"descriptor.original");
                List<TypeParameterDescriptor> list3 = propertyDescriptor2.getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"descriptor.original.typeParameters");
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl12 = false;
                    KotlinType kotlinType3 = typeArguments2.get(it);
                    if (kotlinType3 == null) {
                        Intrinsics.throwNpe();
                    }
                    IrType irType = this.toIrType(kotlinType3);
                    collection.add(irType);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            List typeArgumentsList = list2;
            propertyLValueBase = new AccessorPropertyLValue(this.getContext(), this.getScope(), PsiUtilsKt.getStartOffsetSkippingComments(ktExpression), PsiUtilsKt.getEndOffset(ktExpression), origin, propertyIrType, getterSymbol, getterDescriptor, setterSymbol, setterDescriptor, typeArgumentsList, propertyReceiver, superQualifierSymbol);
        } else {
            IrGeneratorContext irGeneratorContext = this.getContext();
            Scope scope = this.getScope();
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktExpression);
            int n2 = PsiUtilsKt.getEndOffset(ktExpression);
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            PropertyDescriptor propertyDescriptor3 = unwrappedPropertyDescriptor.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor3, (String)"unwrappedPropertyDescriptor.original");
            propertyLValueBase = new FieldPropertyLValue(irGeneratorContext, scope, n, n2, origin, symbolTable.referenceField(propertyDescriptor3), propertyIrType, propertyReceiver, superQualifierSymbol);
        }
        return propertyLValueBase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValInitializationInConstructor(PropertyDescriptor descriptor2, ResolvedCall<?> resolvedCall2) {
        if (descriptor2.isVar()) return false;
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) return false;
        DeclarationDescriptor declarationDescriptor = this.getStatementGenerator().getScopeOwner();
        boolean bl = false;
        boolean bl2 = false;
        DeclarationDescriptor it = declarationDescriptor;
        boolean bl3 = false;
        if (!(it instanceof ConstructorDescriptor)) {
            if (!(it instanceof ClassDescriptor)) return false;
        }
        boolean bl4 = true;
        if (!bl4) return false;
        if (!(resolvedCall2.getDispatchReceiver() instanceof ThisClassReceiver)) return false;
        return true;
    }

    private final ClassDescriptor getThisClass() {
        ClassDescriptor classDescriptor2;
        DeclarationDescriptor scopeOwner = this.getStatementGenerator().getScopeOwner();
        DeclarationDescriptor declarationDescriptor = scopeOwner;
        if (declarationDescriptor instanceof ClassConstructorDescriptor) {
            classDescriptor2 = ((ClassConstructorDescriptor)scopeOwner).getContainingDeclaration();
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            classDescriptor2 = (ClassDescriptor)scopeOwner;
        } else {
            DeclarationDescriptor declarationDescriptor2 = scopeOwner.getContainingDeclaration();
            if (declarationDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
        }
        return classDescriptor2;
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayAccessAssignmentReceiver generateArrayAccessAssignmentReceiver(KtArrayAccessExpression ktLeft, IrStatementOrigin origin) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.INDEXED_LVALUE_GET;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.INDEXED_LVALUE_GET");
        ResolvedCall indexedGetResolvedCall = (ResolvedCall)GeneratorKt.get(this, writableSlice, ktLeft);
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.INDEXED_LVALUE_SET;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice2, (String)"BindingContext.INDEXED_LVALUE_SET");
        ResolvedCall indexedSetResolvedCall = (ResolvedCall)GeneratorKt.get(this, writableSlice2, ktLeft);
        KtExpression ktExpression = ktLeft.getArrayExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"ktLeft.arrayExpression!!");
        IrExpression irExpression = this.genExpr(ktExpression);
        List<KtExpression> list2 = ktLeft.getIndexExpressions();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ktLeft.indexExpressions");
        List<KtExpression> list3 = ktLeft.getIndexExpressions();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"ktLeft.indexExpressions");
        Iterable iterable = list3;
        List<KtExpression> list4 = list2;
        IrExpression irExpression2 = irExpression;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtExpression ktExpression2 = (KtExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
            IrExpression irExpression3 = this.genExpr((KtExpression)v6);
            collection.add(irExpression3);
        }
        collection = (List)destination$iv$iv;
        IrStatementOrigin irStatementOrigin = origin;
        int n = PsiUtilsKt.getEndOffset(ktLeft);
        int n2 = PsiUtilsKt.getStartOffsetSkippingComments(ktLeft);
        CallGenerator callGenerator = new CallGenerator(this.getStatementGenerator());
        Function0 function0 = (Function0)new Function0<CallBuilder>(this, indexedSetResolvedCall){
            final /* synthetic */ AssignmentGenerator this$0;
            final /* synthetic */ ResolvedCall $indexedSetResolvedCall;

            @Nullable
            public final CallBuilder invoke() {
                CallBuilder callBuilder;
                ResolvedCall resolvedCall2 = this.$indexedSetResolvedCall;
                if (resolvedCall2 != null) {
                    ResolvedCall resolvedCall3 = resolvedCall2;
                    boolean bl = false;
                    boolean bl2 = false;
                    ResolvedCall it = resolvedCall3;
                    boolean bl3 = false;
                    callBuilder = ArgumentsGenerationUtilsKt.pregenerateCallReceivers(this.this$0.getStatementGenerator(), it);
                } else {
                    callBuilder = null;
                }
                return callBuilder;
            }
            {
                this.this$0 = assignmentGenerator;
                this.$indexedSetResolvedCall = resolvedCall2;
                super(0);
            }
        };
        Function0 function02 = (Function0)new Function0<CallBuilder>(this, indexedGetResolvedCall){
            final /* synthetic */ AssignmentGenerator this$0;
            final /* synthetic */ ResolvedCall $indexedGetResolvedCall;

            @Nullable
            public final CallBuilder invoke() {
                CallBuilder callBuilder;
                ResolvedCall resolvedCall2 = this.$indexedGetResolvedCall;
                if (resolvedCall2 != null) {
                    ResolvedCall resolvedCall3 = resolvedCall2;
                    boolean bl = false;
                    boolean bl2 = false;
                    ResolvedCall it = resolvedCall3;
                    boolean bl3 = false;
                    callBuilder = ArgumentsGenerationUtilsKt.pregenerateCallReceivers(this.this$0.getStatementGenerator(), it);
                } else {
                    callBuilder = null;
                }
                return callBuilder;
            }
            {
                this.this$0 = assignmentGenerator;
                this.$indexedGetResolvedCall = resolvedCall2;
                super(0);
            }
        };
        ResolvedCall resolvedCall2 = indexedSetResolvedCall;
        ResolvedCall resolvedCall3 = indexedGetResolvedCall;
        List list5 = collection;
        List<KtExpression> list6 = list4;
        IrExpression irExpression4 = irExpression2;
        return new ArrayAccessAssignmentReceiver(irExpression4, list6, list5, resolvedCall3, resolvedCall2, (Function0<CallBuilder>)function02, (Function0<CallBuilder>)function0, callGenerator, n2, n, irStatementOrigin);
    }

    public AssignmentGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    public static final /* synthetic */ IrDynamicOperator access$getDynamicAugmentedAssignmentOperator(AssignmentGenerator $this, IElementType operatorToken) {
        return $this.getDynamicAugmentedAssignmentOperator(operatorToken);
    }
}

