/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.InFrameInterceptor;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.page.InFrame;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.SearchContext;

public class InFrameEnricher
extends AbstractSearchContextEnricher {
    public void enrich(SearchContext searchContext, Object objectToEnrich) {
        List<Field> inFrameFields = ReflectionHelper.getFieldsWithAnnotation(objectToEnrich.getClass(), InFrame.class);
        for (Field field : inFrameFields) {
            boolean isAccessible = field.isAccessible();
            if (!isAccessible) {
                field.setAccessible(true);
            }
            InFrame inFrame = field.getAnnotation(InFrame.class);
            int index = inFrame.index();
            String nameOrId = inFrame.nameOrId();
            this.checkInFrameParameters(field, index, nameOrId);
            try {
                this.registerInFrameInterceptor(objectToEnrich, field, index, nameOrId);
            }
            catch (IllegalArgumentException e) {
                throw new GrapheneTestEnricherException("Only org.openqa.selenium.WebElement, Page fragments fields and Page Object fields can be annotated with @InFrame. Check the field: " + field + " declared in the class: " + objectToEnrich.getClass(), e);
            }
            catch (Exception e) {
                throw new GrapheneTestEnricherException(e);
            }
            if (isAccessible) continue;
            field.setAccessible(false);
        }
    }

    public Object[] resolve(SearchContext searchContext, Method method, Object[] resolvedParams) {
        StringBuffer errorMsgBegin = new StringBuffer("");
        LinkedList<Object[]> paramCouple = new LinkedList<Object[]>();
        paramCouple.addAll(ReflectionHelper.getParametersWithAnnotation(method, InFrame.class));
        for (int i = 0; i < resolvedParams.length; ++i) {
            if (paramCouple.get(i) == null || resolvedParams[i] == null) continue;
            Class param = (Class)((Object[])paramCouple.get(i))[0];
            Annotation[] parameterAnnotations = (Annotation[])((Object[])paramCouple.get(i))[1];
            InFrame inFrame = ReflectionHelper.findAnnotation(parameterAnnotations, InFrame.class);
            int index = inFrame.index();
            String nameOrId = inFrame.nameOrId();
            this.checkInFrameParameters(method, param, index, nameOrId);
            try {
                this.registerInFrameInterceptor((GrapheneProxyInstance)resolvedParams[i], index, nameOrId);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new GrapheneTestEnricherException("Only org.openqa.selenium.WebElement, Page fragments fields and Page Object fields can be annotated with @InFrame. Check parameter " + param + " of the method: " + method.getName() + " declared in: " + method.getDeclaringClass(), e);
            }
            catch (Exception e) {
                throw new GrapheneTestEnricherException(e);
            }
        }
        return resolvedParams;
    }

    private void registerInFrameInterceptor(Object objectToEnrich, Field field, int index, String nameOrId) throws IllegalAccessException, ClassNotFoundException {
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)field.get(objectToEnrich);
        this.registerInFrameInterceptor(proxy, index, nameOrId);
    }

    private void registerInFrameInterceptor(GrapheneProxyInstance proxy, int index, String nameOrId) {
        if (index != -1) {
            proxy.registerInterceptor(new InFrameInterceptor(index));
        } else {
            proxy.registerInterceptor(new InFrameInterceptor(nameOrId));
        }
    }

    private void checkInFrameParameters(Field field, int index, String nameOrId) {
        if (this.checkInFrameParameters(index, nameOrId)) {
            throw new GrapheneTestEnricherException("You have to provide either non empty nameOrId or non negative index value of the frame/iframe in the @InFrame. Check field " + field + " declared in: " + field.getDeclaringClass());
        }
    }

    private void checkInFrameParameters(Method method, Class<?> param, int index, String nameOrId) {
        if (this.checkInFrameParameters(index, nameOrId)) {
            throw new GrapheneTestEnricherException("You have to provide either non empty nameOrId or non negative index value of the frame/iframe in the @InFrame. Check parameter " + param + " of the method: " + method.getName() + " declared in: " + method.getDeclaringClass());
        }
    }

    private boolean checkInFrameParameters(int index, String nameOrId) {
        return nameOrId.trim().equals("") && index < 0;
    }

    public int getPrecedence() {
        return 0;
    }
}

