/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.utils;

import java.util.Date;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.PrepareSqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.utils.time.DateFormatter;
import org.slf4j.Logger;

public class SqlUtils {
    public static String sqlParameterToString(Object[] parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Object param : parameters) {
            if (i++ != 0) {
                builder.append(",");
            }
            builder.append(param);
            if (param instanceof NullValue) continue;
            builder.append("(");
            builder.append(param == null ? "null" : param.getClass().getSimpleName());
            builder.append(")");
        }
        return builder.toString();
    }

    public static void printSql(Logger log, SqlRequest sqlRequest) {
        if (log.isDebugEnabled() && sqlRequest.isNotEmpty()) {
            boolean hasParameter = sqlRequest.getParameters() != null && sqlRequest.getParameters().length > 0;
            log.debug("==>  {}: {}", (Object)(hasParameter ? "Preparing" : "  Execute"), (Object)sqlRequest.getSql());
            if (hasParameter) {
                log.debug("==> Parameters: {}", (Object)SqlUtils.sqlParameterToString(sqlRequest.getParameters()));
                if (sqlRequest instanceof PrepareSqlRequest) {
                    log.debug("==>     Native: {}", (Object)sqlRequest.toNativeSql());
                }
            }
        }
    }

    public static String toNativeSql(String sql, Object ... parameters) {
        if (parameters == null) {
            return sql;
        }
        String[] stringParameter = new String[parameters.length];
        int len = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            stringParameter[i] = parameter instanceof Number || parameter instanceof Boolean ? parameter.toString() : (parameter instanceof Date ? "'" + DateFormatter.toString((Date)((Date)parameter), (String)"yyyy-MM-dd HH:mm:ss") + "'" : (parameter instanceof NullValue ? "null" : (parameter == null ? "null" : "'" + parameter + "'")));
            len += stringParameter.length;
        }
        StringBuilder builder = new StringBuilder(sql.length() + len + 16);
        int parameterIndex = 0;
        int sqlLen = sql.length();
        for (int i = 0; i < sqlLen; ++i) {
            char c = sql.charAt(i);
            if (c == '?') {
                if (stringParameter.length >= parameterIndex) {
                    builder.append(stringParameter[parameterIndex++]);
                    continue;
                }
                builder.append("null");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

