/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.LogicalOperation;
import org.hswebframework.ezorm.core.MethodReferenceColumn;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.operator.dml.Join;
import org.hswebframework.ezorm.rdb.operator.dml.Operator;
import org.hswebframework.ezorm.rdb.operator.dml.SelectColumnSupplier;
import org.hswebframework.ezorm.rdb.operator.dml.SortOrderSupplier;
import org.hswebframework.ezorm.rdb.operator.dml.TermSupplier;
import org.hswebframework.ezorm.rdb.operator.dml.query.JoinOperator;
import org.hswebframework.ezorm.rdb.operator.dml.query.Joins;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.query.SelectColumn;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;

public abstract class QueryOperator
implements LogicalOperation<QueryOperator> {
    public abstract QueryOperator select(String ... var1);

    public abstract QueryOperator select(Collection<String> var1);

    public abstract QueryOperator select(SelectColumn ... var1);

    public final QueryOperator select(SelectColumnSupplier ... operators) {
        for (SelectColumnSupplier operator : operators) {
            this.select((SelectColumn)operator.get());
        }
        return this;
    }

    @SafeVarargs
    public final <T> QueryOperator select(MethodReferenceColumn<T> ... columns) {
        return this.select((String[])Arrays.stream(columns).map(MethodReferenceColumn::getColumn).toArray(String[]::new));
    }

    @SafeVarargs
    public final <T> QueryOperator select(StaticMethodReferenceColumn<T> ... columns) {
        return this.select((String[])Arrays.stream(columns).map(StaticMethodReferenceColumn::getColumn).toArray(String[]::new));
    }

    public abstract QueryOperator selectExcludes(Collection<String> var1);

    public QueryOperator selectExcludes(String ... columns) {
        return this.selectExcludes(Arrays.asList(columns));
    }

    @SafeVarargs
    public final <T> QueryOperator selectExcludes(StaticMethodReferenceColumn<T> ... columns) {
        return this.selectExcludes(Arrays.stream(columns).map(StaticMethodReferenceColumn::getColumn).collect(Collectors.toSet()));
    }

    public abstract QueryOperator where(Consumer<Conditional<?>> var1);

    public abstract QueryOperator where(Term var1);

    public abstract QueryOperator where(Collection<Term> var1);

    public abstract QueryOperator setParam(QueryParam var1);

    public final QueryOperator where(TermSupplier ... condition) {
        for (TermSupplier operator : condition) {
            this.where((Term)operator.get());
        }
        return this;
    }

    public abstract QueryOperator join(Join ... var1);

    @SafeVarargs
    public final QueryOperator join(Supplier<Join> ... on) {
        for (Supplier<Join> joinOperator : on) {
            this.join(joinOperator.get());
        }
        return this;
    }

    public final QueryOperator leftJoin(String target, Consumer<JoinOperator> joinOperatorConsumer) {
        JoinOperator operator = Joins.left(target);
        joinOperatorConsumer.accept(operator);
        return this.join(operator.get());
    }

    public final QueryOperator innerJoin(String target, Consumer<JoinOperator> joinOperatorConsumer) {
        JoinOperator operator = Joins.inner(target);
        joinOperatorConsumer.accept(operator);
        return this.join(operator.get());
    }

    public final QueryOperator rightJoin(String target, Consumer<JoinOperator> joinOperatorConsumer) {
        JoinOperator operator = Joins.right(target);
        joinOperatorConsumer.accept(operator);
        return this.join(operator.get());
    }

    public final QueryOperator fullJoin(String target, Consumer<JoinOperator> joinOperatorConsumer) {
        JoinOperator operator = Joins.right(target);
        joinOperatorConsumer.accept(operator);
        return this.join(operator.get());
    }

    public final QueryOperator orderBy(SortOrderSupplier ... operators) {
        for (SortOrderSupplier operator : operators) {
            this.orderBy((SortOrder)operator.get());
        }
        return this;
    }

    public abstract QueryOperator orderBy(SortOrder ... var1);

    public abstract QueryOperator groupBy(Operator<SelectColumn> ... var1);

    public abstract QueryOperator having(Operator<?> ... var1);

    public abstract QueryOperator paging(int var1, int var2);

    public abstract QueryOperator forUpdate();

    public abstract QueryOperator context(Map<String, Object> var1);

    public abstract SqlRequest getSql();

    public abstract <E, R> QueryResultOperator<E, R> fetch(ResultWrapper<E, R> var1);

    public abstract QueryOperator clone();
}

