/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.insert;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.rdb.executor.DefaultBatchSqlRequest;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.InsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.FunctionColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;

public class MultiInsertSqlBuilder
implements InsertSqlBuilder {
    private RDBTableMetadata table;

    @Override
    public SqlRequest build(InsertOperatorParameter parameter) {
        DefaultBatchSqlRequest sqlRequest = new DefaultBatchSqlRequest();
        LinkedHashMap<Integer, RDBColumnMetadata> indexMapping = new LinkedHashMap<Integer, RDBColumnMetadata>();
        LinkedHashMap<Integer, SqlFragments> functionValues = new LinkedHashMap<Integer, SqlFragments>();
        int index = 0;
        Set<InsertColumn> columns = parameter.getColumns();
        for (InsertColumn insertColumn2 : columns) {
            RDBColumnMetadata columnMetadata = Optional.ofNullable(insertColumn2.getColumn()).flatMap(this.table::getColumn).orElse(null);
            if (columnMetadata != null && columnMetadata.isInsertable()) {
                indexMapping.put(index, columnMetadata);
                SqlFragments functionFragments = Optional.of(insertColumn2).flatMap(insertColumn -> Optional.ofNullable(insertColumn.getFunction()).flatMap(function -> columnMetadata.findFeature(FunctionFragmentBuilder.createFeatureId(function))).map(builder -> builder.create(columnMetadata.getName(), columnMetadata, (FunctionColumn)insertColumn))).orElse(EmptySqlFragments.INSTANCE);
                if (functionFragments.isNotEmpty()) {
                    functionValues.put(index, functionFragments);
                }
            }
            ++index;
        }
        if (indexMapping.isEmpty()) {
            throw new IllegalArgumentException("No operable columns");
        }
        for (List list : parameter.getValues()) {
            PrepareSqlFragments intoSql = PrepareSqlFragments.of();
            PrepareSqlFragments valuesSql = PrepareSqlFragments.of();
            intoSql.addSql("insert into").addSql(this.table.getFullName()).addSql("(");
            valuesSql.addSql("values (");
            int valueLen = list.size();
            int vIndex = 0;
            for (Map.Entry entry : indexMapping.entrySet()) {
                Object value;
                RDBColumnMetadata column = (RDBColumnMetadata)entry.getValue();
                SqlFragments function = (SqlFragments)functionValues.get(vIndex);
                if (null != function) {
                    valuesSql.addFragments(function);
                }
                Object object = value = valueLen <= vIndex ? null : (Object)list.get(vIndex);
                if (vIndex++ != 0) {
                    intoSql.addSql(",");
                    valuesSql.addSql(",");
                }
                intoSql.addSql(column.getQuoteName());
                if ((value == null || value instanceof NullValue) && column.getDefaultValue() instanceof RuntimeDefaultValue) {
                    value = ((RuntimeDefaultValue)column.getDefaultValue()).get();
                }
                if (value instanceof NativeSql) {
                    valuesSql.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                if (value == null) {
                    value = NullValue.of(column.getType());
                }
                valuesSql.addSql("?").addParameter(column.encode(value));
            }
            intoSql.addSql(")");
            valuesSql.addSql(")");
            sqlRequest.addBatch(intoSql.addFragments(valuesSql).toRequest());
        }
        return sqlRequest;
    }

    private MultiInsertSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }

    public static MultiInsertSqlBuilder of(RDBTableMetadata table) {
        return new MultiInsertSqlBuilder(table);
    }
}

