/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl;

import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;

public class AlterRequest {
    private RDBTableMetadata newTable;
    private RDBTableMetadata oldTable;
    private boolean allowDrop;
    private boolean allowAlter = true;
    private boolean allowIndexAlter = true;

    public static AlterRequestBuilder builder() {
        return new AlterRequestBuilder();
    }

    public RDBTableMetadata getNewTable() {
        return this.newTable;
    }

    public RDBTableMetadata getOldTable() {
        return this.oldTable;
    }

    public boolean isAllowDrop() {
        return this.allowDrop;
    }

    public boolean isAllowAlter() {
        return this.allowAlter;
    }

    public boolean isAllowIndexAlter() {
        return this.allowIndexAlter;
    }

    public void setNewTable(RDBTableMetadata newTable) {
        this.newTable = newTable;
    }

    public void setOldTable(RDBTableMetadata oldTable) {
        this.oldTable = oldTable;
    }

    public void setAllowDrop(boolean allowDrop) {
        this.allowDrop = allowDrop;
    }

    public void setAllowAlter(boolean allowAlter) {
        this.allowAlter = allowAlter;
    }

    public void setAllowIndexAlter(boolean allowIndexAlter) {
        this.allowIndexAlter = allowIndexAlter;
    }

    public AlterRequest(RDBTableMetadata newTable, RDBTableMetadata oldTable, boolean allowDrop, boolean allowAlter, boolean allowIndexAlter) {
        this.newTable = newTable;
        this.oldTable = oldTable;
        this.allowDrop = allowDrop;
        this.allowAlter = allowAlter;
        this.allowIndexAlter = allowIndexAlter;
    }

    public AlterRequest() {
    }

    public static class AlterRequestBuilder {
        private RDBTableMetadata newTable;
        private RDBTableMetadata oldTable;
        private boolean allowDrop;
        private boolean allowAlter;
        private boolean allowIndexAlter;

        AlterRequestBuilder() {
        }

        public AlterRequestBuilder newTable(RDBTableMetadata newTable) {
            this.newTable = newTable;
            return this;
        }

        public AlterRequestBuilder oldTable(RDBTableMetadata oldTable) {
            this.oldTable = oldTable;
            return this;
        }

        public AlterRequestBuilder allowDrop(boolean allowDrop) {
            this.allowDrop = allowDrop;
            return this;
        }

        public AlterRequestBuilder allowAlter(boolean allowAlter) {
            this.allowAlter = allowAlter;
            return this;
        }

        public AlterRequestBuilder allowIndexAlter(boolean allowIndexAlter) {
            this.allowIndexAlter = allowIndexAlter;
            return this;
        }

        public AlterRequest build() {
            return new AlterRequest(this.newTable, this.oldTable, this.allowDrop, this.allowAlter, this.allowIndexAlter);
        }

        public String toString() {
            return "AlterRequest.AlterRequestBuilder(newTable=" + this.newTable + ", oldTable=" + this.oldTable + ", allowDrop=" + this.allowDrop + ", allowAlter=" + this.allowAlter + ", allowIndexAlter=" + this.allowIndexAlter + ")";
        }
    }
}

