/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.defaults;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.SimpleNestConditional;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.events.ContextKeys;
import org.hswebframework.ezorm.rdb.mapping.DSLDelete;
import org.hswebframework.ezorm.rdb.mapping.events.EventResultOperator;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.dml.delete.DeleteOperator;
import org.hswebframework.ezorm.rdb.operator.dml.delete.DeleteResultOperator;

public class DefaultDelete<ME extends DSLDelete<?>>
implements DSLDelete<ME> {
    protected List<Term> terms = new ArrayList<Term>();
    protected TermTypeConditionalSupport.Accepter<ME, Object> accepter = (string, string2, object) -> this.and(string, string2, object);
    protected DeleteOperator operator;
    private RDBTableMetadata metadata;
    protected List<ContextKeyValue<?>> contextKeyValues = new ArrayList();

    public DefaultDelete(RDBTableMetadata tableMetadata, DeleteOperator operator, ContextKeyValue<?> ... mapping) {
        this.operator = operator;
        this.metadata = tableMetadata;
        this.contextKeyValues.add(ContextKeys.source(this));
        this.contextKeyValues.add(MappingContextKeys.delete(operator));
        this.contextKeyValues.add(ContextKeys.tableMetadata(tableMetadata));
        this.contextKeyValues.addAll(Arrays.asList(mapping));
    }

    protected DeleteResultOperator doExecute() {
        return EventResultOperator.create(() -> this.operator.where(dsl -> this.terms.forEach(arg_0 -> ((Conditional)dsl).accept(arg_0))).execute(), DeleteResultOperator.class, this.metadata, MappingEventTypes.delete_before, MappingEventTypes.delete_after, this.contextKeyValues.toArray(new ContextKeyValue[0]));
    }

    @Override
    public QueryParam toQueryParam() {
        return this.toQueryParam(QueryParam::new);
    }

    @Override
    public <T extends QueryParam> T toQueryParam(Supplier<T> template) {
        QueryParam param = (QueryParam)template.get();
        param.setTerms(this.terms);
        param.setPaging(false);
        return (T)param;
    }

    public NestConditional<ME> nest() {
        Term term = new Term();
        term.setType(Term.Type.and);
        this.terms.add(term);
        return new SimpleNestConditional((TermTypeConditionalSupport)this, term);
    }

    public NestConditional<ME> orNest() {
        Term term = new Term();
        term.setType(Term.Type.or);
        this.terms.add(term);
        return new SimpleNestConditional((TermTypeConditionalSupport)this, term);
    }

    public ME and() {
        this.accepter = (string, string2, object) -> this.and(string, string2, object);
        return (ME)this;
    }

    public ME or() {
        this.accepter = (string, string2, object) -> this.or(string, string2, object);
        return (ME)this;
    }

    public ME and(String column, String termType, Object value) {
        if (value != null) {
            Term term = new Term();
            term.setColumn(column);
            term.setTermType(termType);
            term.setValue(value);
            term.setType(Term.Type.and);
            this.terms.add(term);
        }
        return (ME)this;
    }

    public ME or(String column, String termType, Object value) {
        if (value != null) {
            Term term = new Term();
            term.setColumn(column);
            term.setTermType(termType);
            term.setValue(value);
            term.setType(Term.Type.or);
            this.terms.add(term);
        }
        return (ME)this;
    }

    public TermTypeConditionalSupport.Accepter<ME, Object> getAccepter() {
        return this.accepter;
    }

    public ME accept(Term term) {
        this.terms.add(term);
        return (ME)this;
    }
}

