/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.Decoder;
import org.hswebframework.ezorm.rdb.executor.wrapper.ConsumerResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ConvertResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ListResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.LowerCaseColumnResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.MapResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.SingleColumnResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.SingleResultWrapper;

public abstract class ResultWrappers {
    public static <E, R> ResultWrapper<E, R> lowerCase(ResultWrapper<E, R> wrapper) {
        return LowerCaseColumnResultWrapper.of(wrapper);
    }

    public static ResultWrapper<Map<String, Object>, Map<String, Object>> map() {
        return MapResultWrapper.defaultInstance();
    }

    public static ResultWrapper<Map<String, Object>, List<Map<String, Object>>> mapList() {
        return ResultWrappers.list(ResultWrappers.map());
    }

    public static ResultWrapper<Map<String, Object>, Stream<Map<String, Object>>> mapStream() {
        return ResultWrappers.stream(ResultWrappers.map());
    }

    public static <E> ResultWrapper<E, Set<E>> set(ResultWrapper<E, ?> wrapper) {
        return ListResultWrapper.of(wrapper, new LinkedHashSet());
    }

    public static <E> ResultWrapper<E, Stream<E>> stream(ResultWrapper<E, ?> wrapper) {
        return ResultWrappers.convert(ResultWrappers.list(wrapper), Collection::stream);
    }

    public static ResultWrapper<Map<String, Object>, Map<String, Object>> singleMap() {
        return ResultWrappers.single(ResultWrappers.map());
    }

    public static <E> ResultWrapper<E, List<E>> list(ResultWrapper<E, ?> wrapper) {
        return ListResultWrapper.of(wrapper, new ArrayList());
    }

    public static <E, R> ResultWrapper<E, Optional<R>> optional(ResultWrapper<E, R> wrapper) {
        return ResultWrappers.convert(wrapper, Optional::ofNullable);
    }

    public static <E> ResultWrapper<E, E> single(ResultWrapper<E, ?> wrapper) {
        return new SingleResultWrapper<E>(wrapper);
    }

    public static <R> ResultWrapper<R, R> column(String column, Decoder<R> decoder) {
        return new SingleColumnResultWrapper<R>(column, decoder);
    }

    public static <E> ResultWrapper<E, Integer> consumer(ResultWrapper<E, ?> wrapper, Consumer<E> consumer) {
        return new ConsumerResultWrapper<E>(wrapper, consumer);
    }

    public static <E> ResultWrapper<E, Integer> consumer(ResultWrapper<E, ?> wrapper, Consumer<E> consumer, Runnable onCompleted) {
        return new ConsumerResultWrapper<E>(wrapper, consumer, onCompleted);
    }

    public static <E, R, C> ResultWrapper<E, C> convert(ResultWrapper<E, R> wrapper, Function<R, C> converter) {
        return new ConvertResultWrapper<E, R, C>(wrapper, converter);
    }

    ResultWrappers() {
    }
}

