/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor.jdbc;

import java.io.ByteArrayInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hswebframework.ezorm.rdb.executor.NullValue;

public class JdbcSqlExecutorHelper {
    public static List<String> getResultColumns(ResultSetMetaData metaData) {
        int count = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(count);
        for (int i = 1; i <= count; ++i) {
            columns.add(metaData.getColumnLabel(i));
        }
        return columns;
    }

    protected static void preparedStatementParameter(PreparedStatement statement, Object[] parameter) throws SQLException {
        if (parameter == null || parameter.length == 0) {
            return;
        }
        int index = 1;
        for (Object object : parameter) {
            if (object == null) {
                statement.setNull(index++, 0);
                continue;
            }
            if (object instanceof NullValue) {
                statement.setNull(index++, ((NullValue)object).getDataType().getSqlType().getVendorTypeNumber());
                continue;
            }
            if (object instanceof Date) {
                statement.setTimestamp(index++, new Timestamp(((Date)object).getTime()));
                continue;
            }
            if (object instanceof byte[]) {
                statement.setBlob(index++, new ByteArrayInputStream((byte[])object));
                continue;
            }
            statement.setObject(index++, object);
        }
    }
}

