/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Function;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.core.utils.StringUtils;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.utils.time.DateFormatter;

public class NumberValueCodec
implements ValueCodec<Object, Object> {
    private final Function<Number, Object> converter;

    public NumberValueCodec(Function<Number, Object> converter) {
        this.converter = converter;
    }

    public NumberValueCodec(Class<?> javaType) {
        if (javaType == Integer.TYPE || javaType == Integer.class) {
            this.converter = Number::intValue;
        } else if (javaType == Double.TYPE || javaType == Double.class) {
            this.converter = Number::doubleValue;
        } else if (javaType == Float.TYPE || javaType == Float.class) {
            this.converter = Number::floatValue;
        } else if (javaType == Long.TYPE || javaType == Long.class) {
            this.converter = Number::longValue;
        } else if (javaType == Byte.TYPE || javaType == Byte.class) {
            this.converter = Number::byteValue;
        } else if (javaType == Short.TYPE || javaType == Short.class) {
            this.converter = Number::shortValue;
        } else if (javaType == Boolean.TYPE || javaType == Boolean.class) {
            this.converter = num -> num.byteValue() != 0;
        } else if (Date.class.isAssignableFrom(javaType)) {
            Constructor<?> constructor = javaType.getConstructor(new Class[0]);
            this.converter = num -> {
                try {
                    Date date = (Date)constructor.newInstance(new Object[0]);
                    date.setTime(num.longValue());
                    return date;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        } else {
            this.converter = num -> num;
        }
    }

    private Object tryCastNumber(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof NullValue) {
            return value;
        }
        if (value instanceof Date) {
            value = ((Date)value).getTime();
        } else if (value instanceof LocalDateTime) {
            value = ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        } else if (value instanceof ZonedDateTime) {
            value = ((ZonedDateTime)value).toInstant().toEpochMilli();
        } else if (value instanceof String) {
            Date date = DateFormatter.fromString((String)String.valueOf(value));
            value = null != date ? Long.valueOf(date.getTime()) : new BigDecimal(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.converter.apply((Number)value);
        }
        if (Boolean.TRUE.equals(value)) {
            return this.converter.apply(1);
        }
        if (Boolean.FALSE.equals(value)) {
            return this.converter.apply(0);
        }
        throw new IllegalArgumentException("\u503c" + value + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57");
    }

    public Object encode(Object value) {
        if (StringUtils.isNullOrEmpty((Object)value)) {
            return null;
        }
        return this.tryCastNumber(value);
    }

    public Object decode(Object data) {
        return this.tryCastNumber(data);
    }
}

