/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.api.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.hswebframework.web.event.DefaultAsyncEvent;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ClearUserAuthorizationCacheEvent
extends DefaultAsyncEvent {
    private Set<String> userId;
    private boolean all;
    private boolean async;
    private static final String DISABLE_KEY = ClearUserAuthorizationCacheEvent.class + "_Disabled";

    public static <T> Flux<T> disable(Flux<T> task) {
        return task.contextWrite((ContextView)Context.of((Object)DISABLE_KEY, (Object)true));
    }

    public static <T> Mono<T> disable(Mono<T> task) {
        return task.contextWrite((ContextView)Context.of((Object)DISABLE_KEY, (Object)true));
    }

    public static Mono<Void> doOnEnabled(Mono<Void> task) {
        return Mono.deferContextual(ctx -> {
            if (ctx.hasKey((Object)DISABLE_KEY)) {
                return Mono.empty();
            }
            return task;
        });
    }

    public synchronized void async(Publisher<?> publisher) {
        super.async(ClearUserAuthorizationCacheEvent.doOnEnabled((Mono<Void>)Mono.fromDirect(publisher).then()));
    }

    public static ClearUserAuthorizationCacheEvent of(Collection<String> collection) {
        ClearUserAuthorizationCacheEvent event = new ClearUserAuthorizationCacheEvent();
        if (collection == null || collection.isEmpty()) {
            event.all = true;
        } else {
            event.userId = new HashSet<String>(collection);
        }
        return event;
    }

    public static ClearUserAuthorizationCacheEvent all() {
        return ClearUserAuthorizationCacheEvent.of((String[])null);
    }

    public ClearUserAuthorizationCacheEvent useAsync() {
        this.async = true;
        return this;
    }

    public Mono<Void> publish(ApplicationEventPublisher eventPublisher) {
        this.async = true;
        return super.publish(eventPublisher);
    }

    public static ClearUserAuthorizationCacheEvent of(String ... userId) {
        return ClearUserAuthorizationCacheEvent.of(userId == null ? null : Arrays.asList(userId));
    }

    public Set<String> getUserId() {
        return this.userId;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isAsync() {
        return this.async;
    }
}

