/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.system.authorization.api.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.bean.ToString;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.util.StringUtils;

@Table(name="s_user", indexes={@Index(name="user_username_idx", columnList="username", unique=true)})
@Comment(value="\u7528\u6237\u4fe1\u606f")
public class UserEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Column(length=128, nullable=false)
    @NotBlank(message="\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u59d3\u540d")
    private @NotBlank(message="\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String name;
    @Column(length=128, nullable=false, updatable=false)
    @NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u7528\u6237\u540d")
    private @NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String username;
    @Column(nullable=false)
    @ToString.Ignore(cover=false)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @NotBlank(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u5bc6\u7801")
    private @NotBlank(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String password;
    @Column(nullable=false)
    @ToString.Ignore(cover=false)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Schema(description="\u52a0\u5bc6\u76d0\u503c")
    @Hidden
    private String salt;
    @Column
    @Schema(description="\u7528\u6237\u7c7b\u578b")
    private String type;
    @Column
    @DefaultValue(value="1")
    @Schema(description="\u7528\u6237\u72b6\u6001")
    private Byte status;
    @Column(name="creator_id", updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID")
    @Hidden
    private String creatorId;
    @Column(name="create_time", updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @Hidden
    private Long createTime;

    public String getId() {
        return (String)super.getId();
    }

    public void generateId() {
        if (StringUtils.hasText((String)this.getId())) {
            return;
        }
        this.setId(DigestUtils.md5Hex((String)this.username));
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getType() {
        return this.type;
    }

    public Byte getStatus() {
        return this.status;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

