/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler.access;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.authorization.access.DataAccessConfig;
import org.hswebframework.web.authorization.access.DataAccessHandler;
import org.hswebframework.web.authorization.access.FieldFilterDataAccessConfig;
import org.hswebframework.web.authorization.basic.handler.access.InvokeResultUtils;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.Phased;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FieldFilterDataAccessHandler
implements DataAccessHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean isSupport(DataAccessConfig access) {
        return access instanceof FieldFilterDataAccessConfig;
    }

    public boolean handle(DataAccessConfig access, AuthorizingContext context) {
        FieldFilterDataAccessConfig filterDataAccessConfig = (FieldFilterDataAccessConfig)access;
        switch (access.getAction()) {
            case "query": 
            case "get": {
                return this.doQueryAccess(filterDataAccessConfig, context);
            }
            case "add": 
            case "save": 
            case "update": {
                return this.doUpdateAccess(filterDataAccessConfig, context);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("field filter not support for {}", (Object)access.getAction());
        }
        return true;
    }

    protected void applyUpdateParam(FieldFilterDataAccessConfig config, Object ... parameter) {
        for (Object data : parameter) {
            for (String field : config.getFields()) {
                try {
                    BeanUtilsBean.getInstance().getPropertyUtils().setProperty(data, field, null);
                }
                catch (Exception e) {
                    this.logger.warn("can't set {} null", (Object)field, (Object)e);
                }
            }
        }
    }

    protected boolean doUpdateAccess(FieldFilterDataAccessConfig accesses, AuthorizingContext params) {
        boolean reactive = params.getParamContext().handleReactiveArguments(publisher -> {
            if (publisher instanceof Mono) {
                return Mono.from((Publisher)publisher).doOnNext(data -> this.applyUpdateParam(accesses, data));
            }
            if (publisher instanceof Flux) {
                return Flux.from((Publisher)publisher).doOnNext(data -> this.applyUpdateParam(accesses, data));
            }
            return publisher;
        });
        if (reactive) {
            return true;
        }
        this.applyUpdateParam(accesses, params.getParamContext().getArguments());
        return true;
    }

    protected void applyQueryParam(FieldFilterDataAccessConfig config, Object param) {
        if (param instanceof QueryParam) {
            Set denyFields = config.getFields();
            ((QueryParam)param).excludes(denyFields.toArray(new String[0]));
            return;
        }
        Object r = InvokeResultUtils.convertRealResult(param);
        if (r instanceof Collection) {
            ((Collection)r).forEach(o -> this.setObjectPropertyNull(o, config.getFields()));
        } else {
            this.setObjectPropertyNull(r, config.getFields());
        }
    }

    protected boolean doQueryAccess(FieldFilterDataAccessConfig access, AuthorizingContext context) {
        if (context.getDefinition().getResources().getPhased() == Phased.before) {
            boolean reactive = context.getParamContext().handleReactiveArguments(publisher -> {
                if (publisher instanceof Mono) {
                    return Mono.from((Publisher)publisher).doOnNext(param -> this.applyQueryParam(access, param));
                }
                return publisher;
            });
            if (reactive) {
                return true;
            }
            for (Object argument : context.getParamContext().getArguments()) {
                this.applyQueryParam(access, argument);
            }
        } else {
            if (context.getParamContext().getInvokeResult() instanceof Publisher) {
                context.getParamContext().setInvokeResult((Object)Flux.from((Publisher)((Publisher)context.getParamContext().getInvokeResult())).doOnNext(result -> this.applyQueryParam(access, result)));
                return true;
            }
            this.applyQueryParam(access, context.getParamContext().getInvokeResult());
        }
        return true;
    }

    protected void setObjectPropertyNull(Object obj, Set<String> fields) {
        if (null == obj) {
            return;
        }
        for (String field : fields) {
            try {
                BeanUtilsBean.getInstance().getPropertyUtils().setProperty(obj, field, null);
            }
            catch (Exception exception) {}
        }
    }
}

