/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.embed;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationInfo;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.authorization.simple.builder.SimpleDataAccessConfigBuilderFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="hsweb.auth")
public class EmbedAuthenticationProperties
implements InitializingBean {
    private Map<String, Authentication> authentications = new HashMap<String, Authentication>();
    private Map<String, EmbedAuthenticationInfo> users = new HashMap<String, EmbedAuthenticationInfo>();
    @Autowired(required=false)
    private DataAccessConfigBuilderFactory dataAccessConfigBuilderFactory = new SimpleDataAccessConfigBuilderFactory();

    public void afterPropertiesSet() {
        this.users.forEach((id, properties) -> {
            if (org.springframework.util.StringUtils.isEmpty((Object)properties.getId())) {
                properties.setId((String)id);
            }
            for (EmbedAuthenticationInfo.PermissionInfo permissionInfo : properties.getPermissions()) {
                for (Map<String, Object> objectMap : permissionInfo.getDataAccesses()) {
                    for (Map.Entry<String, Object> stringObjectEntry : objectMap.entrySet()) {
                        Map mapVal;
                        boolean maybeIsList;
                        if (!(stringObjectEntry.getValue() instanceof Map) || !(maybeIsList = (mapVal = (Map)stringObjectEntry.getValue()).keySet().stream().allMatch(StringUtils::isInt))) continue;
                        stringObjectEntry.setValue(mapVal.values());
                    }
                }
            }
            this.authentications.put((String)id, properties.toAuthentication(this.dataAccessConfigBuilderFactory));
        });
    }

    public Authentication authenticate(AuthenticationRequest request) {
        if (MapUtils.isEmpty(this.users)) {
            return null;
        }
        if (request instanceof PlainTextUsernamePasswordAuthenticationRequest) {
            PlainTextUsernamePasswordAuthenticationRequest pwdReq = (PlainTextUsernamePasswordAuthenticationRequest)request;
            for (EmbedAuthenticationInfo user : this.users.values()) {
                if (!pwdReq.getUsername().equals(user.getUsername())) continue;
                if (pwdReq.getPassword().equals(user.getPassword())) {
                    return user.toAuthentication(this.dataAccessConfigBuilderFactory);
                }
                return null;
            }
            return null;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6388\u6743\u8bf7\u6c42:" + request);
    }

    public Optional<Authentication> getAuthentication(String userId) {
        return Optional.ofNullable(this.authentications.get(userId));
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public DataAccessConfigBuilderFactory getDataAccessConfigBuilderFactory() {
        return this.dataAccessConfigBuilderFactory;
    }

    public void setAuthentications(Map<String, Authentication> authentications) {
        this.authentications = authentications;
    }

    public void setDataAccessConfigBuilderFactory(DataAccessConfigBuilderFactory dataAccessConfigBuilderFactory) {
        this.dataAccessConfigBuilderFactory = dataAccessConfigBuilderFactory;
    }

    public Map<String, EmbedAuthenticationInfo> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, EmbedAuthenticationInfo> users) {
        this.users = users;
    }
}

