/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.core.facade.MavenContextImpl;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.osgi.adapters.MavenLoggerAdapter;

@Component(role=EquinoxLifecycleListener.class, hint="MavenContextConfigurator")
public class MavenContextConfigurator
extends EquinoxLifecycleListener {
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport context;

    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        MavenSession session = this.context.getSession();
        File localRepoRoot = new File(session.getLocalRepository().getBasedir());
        MavenLoggerAdapter mavenLogger = new MavenLoggerAdapter(this.logger, false);
        Properties globalProps = this.getGlobalProperties(session);
        MavenContextImpl mavenContext = new MavenContextImpl(localRepoRoot, session.isOffline(), (MavenLogger)mavenLogger, globalProps);
        framework.registerService(MavenContext.class, (Object)mavenContext);
    }

    private Properties getGlobalProperties(MavenSession session) {
        Properties globalProps = new Properties();
        globalProps.putAll((Map<?, ?>)session.getSystemProperties());
        Settings settings = session.getSettings();
        Map profileMap = settings.getProfilesAsMap();
        for (String profileId : settings.getActiveProfiles()) {
            Profile profile = (Profile)profileMap.get(profileId);
            if (profile == null) continue;
            globalProps.putAll((Map<?, ?>)profile.getProperties());
        }
        globalProps.putAll((Map<?, ?>)session.getUserProperties());
        return globalProps;
    }
}

