/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TargetPlatformResolver;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentConfigurationImpl;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformConfigurationReader;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformResolverFactory;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.resolver.DependencyVisitor;
import org.eclipse.tycho.resolver.TychoDependencyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=TychoDependencyResolver.class)
public class DefaultTychoDependencyResolver
implements TychoDependencyResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private DefaultTargetPlatformConfigurationReader configurationReader;
    @Requirement
    private DefaultTargetPlatformResolverFactory targetPlatformResolverLocator;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public void setupProject(MavenSession session, MavenProject project, ReactorProject reactorProject) {
        AbstractTychoProject dr = (AbstractTychoProject)this.projectTypes.get(project.getPackaging());
        if (dr == null) {
            return;
        }
        if (project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES) != null) {
            return;
        }
        dr.setupProject(session, project);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)session.getSystemProperties());
        properties.putAll((Map<?, ?>)session.getUserProperties());
        project.setContextValue(TychoConstants.CTX_MERGED_PROPERTIES, (Object)properties);
        TargetPlatformConfiguration configuration = this.configurationReader.getTargetPlatformConfiguration(session, project);
        project.setContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION, (Object)configuration);
        ExecutionEnvironmentConfigurationImpl eeConfiguration = new ExecutionEnvironmentConfigurationImpl(this.logger);
        dr.readExecutionEnvironmentConfiguration(project, eeConfiguration);
        project.setContextValue(TychoConstants.CTX_EXECUTION_ENVIRONMENT_CONFIGURATION, (Object)eeConfiguration);
        TargetPlatformResolver resolver = this.targetPlatformResolverLocator.lookupPlatformResolver(project);
        resolver.setupProjects(session, project, reactorProject);
    }

    public void resolveProject(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects) {
        StringBuilder sb;
        AbstractTychoProject dr = (AbstractTychoProject)this.projectTypes.get(project.getPackaging());
        if (dr == null) {
            return;
        }
        TargetPlatformResolver resolver = this.targetPlatformResolverLocator.lookupPlatformResolver(project);
        this.logger.info("Computing target platform for " + project);
        TargetPlatform targetPlatform = resolver.computeTargetPlatform(session, project, reactorProjects, true);
        dr.setTargetPlatform(project, targetPlatform);
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration(project);
        DependencyResolverConfiguration resolverConfiguration = configuration.getDependencyResolverConfiguration();
        this.logger.info("Resolving dependencies of " + project);
        DependencyArtifacts dependencyArtifacts = resolver.resolveDependencies(session, project, targetPlatform, reactorProjects, resolverConfiguration);
        if (this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(session, project)) {
            sb = new StringBuilder();
            sb.append("Resolved target platform for ").append(project).append("\n");
            dependencyArtifacts.toDebugString(sb, "  ");
            this.logger.debug(sb.toString());
        }
        dr.setDependencyArtifacts(session, project, dependencyArtifacts);
        this.logger.info("Resolving class path of " + project);
        dr.resolveClassPath(session, project);
        resolver.injectDependenciesIntoMavenModel(project, dr, dependencyArtifacts, this.logger);
        if (this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(session, project)) {
            sb = new StringBuilder();
            sb.append("Injected dependencies for ").append(project.toString()).append("\n");
            for (Dependency dependency : project.getDependencies()) {
                sb.append("  ").append(dependency.toString());
            }
            this.logger.debug(sb.toString());
        }
    }

    public void traverse(MavenProject project, final DependencyVisitor visitor) {
        TychoProject tychoProject = this.projectTypes.get(project.getPackaging());
        if (tychoProject != null) {
            tychoProject.getDependencyWalker(project).walk(new ArtifactDependencyVisitor(){

                public void visitPlugin(PluginDescription plugin) {
                    visitor.visit((ArtifactDescriptor)plugin);
                }

                public boolean visitFeature(FeatureDescription feature) {
                    return visitor.visit((ArtifactDescriptor)feature);
                }
            });
        }
    }
}

