/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultArtifactDescriptor;
import org.eclipse.tycho.core.osgitools.DefaultArtifactKey;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDependencyArtifacts {
    private static final Version VERSION_0_0_0 = new Version("0.0.0");
    protected final Map<ArtifactKey, ArtifactDescriptor> artifacts = new LinkedHashMap<ArtifactKey, ArtifactDescriptor>();
    protected final Map<File, Map<String, ArtifactDescriptor>> locations = new LinkedHashMap<File, Map<String, ArtifactDescriptor>>();

    public List<ArtifactDescriptor> getArtifacts(String type) {
        ArrayList<ArtifactDescriptor> result = new ArrayList<ArtifactDescriptor>();
        for (Map.Entry<ArtifactKey, ArtifactDescriptor> entry : this.artifacts.entrySet()) {
            if (!type.equals(entry.getKey().getType())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public List<ArtifactDescriptor> getArtifacts() {
        return new ArrayList<ArtifactDescriptor>(this.artifacts.values());
    }

    public void addArtifactFile(ArtifactKey key, File location, Set<Object> installableUnits) {
        this.addArtifact(new DefaultArtifactDescriptor(key, location, null, null, installableUnits));
    }

    public void addArtifact(ArtifactDescriptor artifact) {
        this.addArtifact(artifact, false);
    }

    protected void addArtifact(ArtifactDescriptor artifact, boolean merge) {
        if (artifact.getClass() != DefaultArtifactDescriptor.class) {
            throw new IllegalAccessError();
        }
        ArtifactKey key = this.normalizePluginType(artifact.getKey());
        File location = BasicDependencyArtifacts.normalizeLocation(artifact.getLocation());
        ArtifactDescriptor original = this.artifacts.get(key);
        Set<Object> units = null;
        if (original != null) {
            if (!(BasicDependencyArtifacts.eq(original.getLocation(), location) && BasicDependencyArtifacts.eq(original.getClassifier(), artifact.getClassifier()) && BasicDependencyArtifacts.eq(original.getMavenProject(), artifact.getMavenProject()))) {
                throw new IllegalStateException("Inconsistent artifact with key " + artifact.getKey());
            }
            if (BasicDependencyArtifacts.eq(original.getInstallableUnits(), artifact.getInstallableUnits())) {
                return;
            }
            if (!merge) {
                throw new IllegalStateException("Inconsistent artifact with key " + artifact.getKey());
            }
            units = new LinkedHashSet<Object>(original.getInstallableUnits());
            units.addAll(artifact.getInstallableUnits());
        } else {
            units = artifact.getInstallableUnits();
        }
        key = this.normalize(key);
        if (units != null) {
            units = Collections.unmodifiableSet(units);
        }
        if ((artifact = new DefaultArtifactDescriptor(key, location, artifact.getMavenProject(), artifact.getClassifier(), units)).getMavenProject() == null) {
            artifact = this.normalize(artifact);
        }
        this.artifacts.put(artifact.getKey(), artifact);
        Map<String, ArtifactDescriptor> classified = this.locations.get(location);
        if (classified == null) {
            classified = new LinkedHashMap<String, ArtifactDescriptor>();
            this.locations.put(location, classified);
        }
        for (ArtifactDescriptor other : classified.values()) {
            if (BasicDependencyArtifacts.eq(artifact.getMavenProject(), other.getMavenProject())) continue;
            throw new IllegalStateException("Inconsistent reactor project at location " + location + ". " + artifact.getMavenProject() + " is not the same as " + other.getMavenProject());
        }
        classified.put(artifact.getClassifier(), artifact);
    }

    private static File normalizeLocation(File location) {
        return new File(location.getAbsoluteFile().toURI().normalize());
    }

    protected ArtifactDescriptor normalize(ArtifactDescriptor artifact) {
        return artifact;
    }

    protected ArtifactKey normalize(ArtifactKey key) {
        return key;
    }

    protected ArtifactKey normalizePluginType(ArtifactKey key) {
        if ("eclipse-test-plugin".equals(key.getType())) {
            key = new DefaultArtifactKey("eclipse-plugin", key.getId(), key.getVersion());
        }
        return key;
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    public void dump() {
        for (Map.Entry<ArtifactKey, ArtifactDescriptor> entry : this.artifacts.entrySet()) {
            System.out.println(entry.getKey() + "\t" + entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty();
    }

    public ArtifactDescriptor getArtifact(String type, String id, String version) {
        if (type == null || id == null) {
            return null;
        }
        TreeMap<Version, ArtifactDescriptor> relevantArtifacts = new TreeMap<Version, ArtifactDescriptor>(new Comparator<Version>(){

            @Override
            public int compare(Version o1, Version o2) {
                return -o1.compareTo(o2);
            }
        });
        for (Map.Entry<ArtifactKey, ArtifactDescriptor> entry : this.artifacts.entrySet()) {
            ArtifactKey key = entry.getKey();
            if (!type.equals(key.getType()) || !id.equals(key.getId())) continue;
            relevantArtifacts.put(Version.parseVersion((String)key.getVersion()), entry.getValue());
        }
        if (relevantArtifacts.isEmpty()) {
            return null;
        }
        if (version == null) {
            return (ArtifactDescriptor)relevantArtifacts.get(relevantArtifacts.firstKey());
        }
        Version parsedVersion = new Version(version);
        if (VERSION_0_0_0.equals((Object)parsedVersion)) {
            return (ArtifactDescriptor)relevantArtifacts.get(relevantArtifacts.firstKey());
        }
        String qualifier = parsedVersion.getQualifier();
        if (qualifier == null || "".equals(qualifier) || "qualifier".equals(qualifier)) {
            for (Map.Entry entry : relevantArtifacts.entrySet()) {
                if (!BasicDependencyArtifacts.baseVersionEquals(parsedVersion, (Version)entry.getKey())) continue;
                return (ArtifactDescriptor)entry.getValue();
            }
        }
        return (ArtifactDescriptor)relevantArtifacts.get(parsedVersion);
    }

    private static boolean baseVersionEquals(Version v1, Version v2) {
        return v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v2.getMicro();
    }

    public void addReactorArtifact(ArtifactKey key, ReactorProject project, String classifier, Set<Object> installableUnits) {
        DefaultArtifactDescriptor artifact = new DefaultArtifactDescriptor(key, project.getBasedir(), project, classifier, installableUnits);
        this.addArtifact(artifact);
    }

    public ReactorProject getMavenProject(File location) {
        Map<String, ArtifactDescriptor> classified = this.getArtifact(location);
        if (classified != null) {
            return classified.values().iterator().next().getMavenProject();
        }
        return null;
    }

    public Map<String, ArtifactDescriptor> getArtifact(File location) {
        return this.locations.get(BasicDependencyArtifacts.normalizeLocation(location));
    }

    public ArtifactDescriptor getArtifact(ArtifactKey key) {
        return this.artifacts.get(this.normalizePluginType(key));
    }

    public void removeAll(String type, String id) {
        Iterator<Map.Entry<ArtifactKey, ArtifactDescriptor>> iter = this.artifacts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ArtifactKey, ArtifactDescriptor> entry = iter.next();
            ArtifactKey key = entry.getKey();
            if (!key.getType().equals(type) || !key.getId().equals(id)) continue;
            this.locations.remove(entry.getValue().getLocation());
            iter.remove();
        }
    }

    public void toDebugString(StringBuilder sb, String linePrefix) {
        for (ArtifactDescriptor artifact : this.artifacts.values()) {
            sb.append(linePrefix);
            sb.append(artifact.getKey().toString());
            sb.append(": ");
            ReactorProject project = artifact.getMavenProject();
            if (project != null) {
                sb.append(project.toString());
            } else {
                sb.append(artifact.getLocation());
            }
            sb.append("\n");
        }
    }
}

