/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.core.osgitools.AbstractArtifactBasedProject;
import org.eclipse.tycho.core.osgitools.AbstractArtifactDependencyWalker;
import org.eclipse.tycho.core.osgitools.DefaultArtifactKey;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.ProductConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=TychoProject.class, hint="eclipse-repository")
public class EclipseRepositoryProject
extends AbstractArtifactBasedProject {
    @Override
    public ArtifactKey getArtifactKey(ReactorProject project) {
        String id = project.getArtifactId();
        String version = this.getOsgiVersion(project);
        return new DefaultArtifactKey("eclipse-repository", id, version);
    }

    @Override
    protected ArtifactDependencyWalker newDependencyWalker(MavenProject project, TargetEnvironment environment) {
        final List<ProductConfiguration> products = this.loadProducts(project);
        final List<Category> categories = this.loadCategories(project);
        return new AbstractArtifactDependencyWalker(this.getDependencyArtifacts(project, environment), this.getEnvironments(project, environment)){

            public void walk(ArtifactDependencyVisitor visitor) {
                AbstractArtifactDependencyWalker.WalkbackPath visited = new AbstractArtifactDependencyWalker.WalkbackPath();
                for (ProductConfiguration product : products) {
                    this.traverseProduct(product, visitor, visited);
                }
                for (Category category : categories) {
                    for (FeatureRef feature : category.getFeatures()) {
                        this.traverseFeature(feature, visitor, visited);
                    }
                }
            }
        };
    }

    public List<Category> loadCategories(MavenProject project) {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (File file : this.getCategoryFiles(project)) {
            try {
                categories.add(Category.read((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read product configuration file " + file.getAbsolutePath(), e);
            }
        }
        return categories;
    }

    protected List<ProductConfiguration> loadProducts(MavenProject project) {
        ArrayList<ProductConfiguration> products = new ArrayList<ProductConfiguration>();
        for (File file : this.getProductFiles(project)) {
            try {
                products.add(ProductConfiguration.read((File)file));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read product configuration file " + file.getAbsolutePath(), e);
            }
        }
        return products;
    }

    private List<File> getCategoryFiles(MavenProject project) {
        ArrayList<File> res = new ArrayList<File>();
        File categoryFile = new File(project.getBasedir(), "category.xml");
        if (categoryFile.exists()) {
            res.add(categoryFile);
        }
        return res;
    }

    public List<File> getProductFiles(MavenProject project) {
        File projectLocation = project.getBasedir();
        ArrayList<File> res = new ArrayList<File>();
        for (File f : projectLocation.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".product")) continue;
            res.add(f);
        }
        return res;
    }
}

