/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.core.osgitools.targetplatform.MultiEnvironmentTargetPlatform;
import org.eclipse.tycho.core.utils.TychoProjectUtils;

public abstract class AbstractTychoProject
extends AbstractLogEnabled
implements TychoProject {
    public DependencyArtifacts getDependencyArtifacts(MavenProject project) {
        return TychoProjectUtils.getDependencyArtifacts(project);
    }

    public DependencyArtifacts getDependencyArtifacts(MavenProject project, TargetEnvironment environment) {
        DependencyArtifacts platform = this.getDependencyArtifacts(project);
        if (environment != null && platform instanceof MultiEnvironmentTargetPlatform && (platform = ((MultiEnvironmentTargetPlatform)platform).getPlatform(environment)) == null) {
            throw new IllegalStateException("Unsupported runtime environment " + environment.toString() + " for project " + project.toString());
        }
        return platform;
    }

    public void setDependencyArtifacts(MavenSession session, MavenProject project, DependencyArtifacts dependencyArtifacts) {
        project.setContextValue(TychoConstants.CTX_DEPENDENCY_ARTIFACTS, (Object)dependencyArtifacts);
    }

    public void setupProject(MavenSession session, MavenProject project) {
    }

    @Deprecated
    public void checkForMissingDependencies(MavenProject project) {
    }

    public void resolveClassPath(MavenSession session, MavenProject project) {
    }

    protected TargetEnvironment[] getEnvironments(MavenProject project, TargetEnvironment environment) {
        if (environment != null) {
            return new TargetEnvironment[]{environment};
        }
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration(project);
        if (configuration.isImplicitTargetEnvironment()) {
            return null;
        }
        List<TargetEnvironment> environments = configuration.getEnvironments();
        return environments.toArray(new TargetEnvironment[environments.size()]);
    }

    public TargetEnvironment getImplicitTargetEnvironment(MavenProject project) {
        return null;
    }

    public void readExecutionEnvironmentConfiguration(MavenProject project, ExecutionEnvironmentConfiguration sink) {
        String configuredDefaultProfile;
        TargetPlatformConfiguration tpConfiguration = TychoProjectUtils.getTargetPlatformConfiguration(project);
        String configuredForcedProfile = tpConfiguration.getExecutionEnvironment();
        if (configuredForcedProfile != null) {
            sink.overrideProfileConfiguration(configuredForcedProfile, "target-platform-configuration <executionEnvironment>");
        }
        if ((configuredDefaultProfile = tpConfiguration.getExecutionEnvironmentDefault()) != null) {
            sink.setProfileConfiguration(configuredDefaultProfile, "target-platform-configuration <executionEnvironmentDefault>");
        }
    }

    public TargetPlatform getTargetPlatform(MavenProject project) {
        return (TargetPlatform)project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM);
    }

    public void setTargetPlatform(MavenProject project, TargetPlatform targetPlatform) {
        project.setContextValue(TychoConstants.CTX_TARGET_PLATFORM, (Object)targetPlatform);
    }
}

