/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=MavenCompatiblityHelper.class)
public class MavenCompatiblityHelper {
    @Requirement
    private Logger logger;
    @Requirement
    protected MavenPluginManager mavenPluginManager;
    private Method getPluginDescriptorMethod = MavenCompatiblityHelper.getMethod(MavenPluginManager.class, "getPluginDescriptor");
    @Requirement
    private PluginDescriptorCache pluginDescriptorCache;
    private Method createKeyMethod = MavenCompatiblityHelper.getMethod(PluginDescriptorCache.class, "createKey");
    private Method getRepositorySessionMethod = MavenCompatiblityHelper.getMethod(MavenSession.class, "getRepositorySession");

    private static Method getMethod(Class clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        throw new RuntimeException("Method '" + methodName + "' not found for class " + clazz.getName());
    }

    public PluginDescriptor getPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        try {
            List remoteRepositories = project.getRemotePluginRepositories();
            Object repositorySession = this.getRepositorySessionMethod.invoke((Object)session, new Object[0]);
            return (PluginDescriptor)this.getPluginDescriptorMethod.invoke((Object)this.mavenPluginManager, plugin, remoteRepositories, repositorySession);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof PluginResolutionException) {
                throw (PluginResolutionException)target;
            }
            if (target instanceof PluginDescriptorParsingException) {
                throw (PluginDescriptorParsingException)target;
            }
            if (target instanceof InvalidPluginDescriptorException) {
                throw (InvalidPluginDescriptorException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new RuntimeException(e);
        }
    }

    public PluginDescriptorCache.Key createKey(Plugin plugin, MavenProject project, MavenSession session) {
        try {
            Object repositorySession = this.getRepositorySessionMethod.invoke((Object)session, new Object[0]);
            List remoteRepositories = project.getRemotePluginRepositories();
            return (PluginDescriptorCache.Key)this.createKeyMethod.invoke((Object)this.pluginDescriptorCache, plugin, remoteRepositories, repositorySession);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new RuntimeException(e);
        }
    }
}

