/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.Function;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.DateUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.diff.ChangeDelta;
import org.assertj.core.util.diff.DeleteDelta;
import org.assertj.core.util.diff.InsertDelta;

public class StandardRepresentation
implements Representation {
    public static final StandardRepresentation STANDARD_REPRESENTATION = new StandardRepresentation();
    private static final String NULL = "null";
    private static final String TUPLE_START = "(";
    private static final String TUPLE_END = ")";
    private static final String DEFAULT_START = "[";
    private static final String DEFAULT_END = "]";
    private static final String DEFAULT_MAX_ELEMENTS_EXCEEDED = "...";
    static final String INDENTATION_AFTER_NEWLINE = "    ";
    static final String INDENTATION_FOR_SINGLE_LINE = " ";
    public static final String ELEMENT_SEPARATOR = ",";
    public static final String ELEMENT_SEPARATOR_WITH_NEWLINE = "," + System.lineSeparator();
    private static int maxLengthForSingleLineDescription = 80;
    private static final Map<Class<?>, Function<?, String>> customFormatterByType = new HashMap();
    private static int maxElementsForPrinting = 1000;

    public static void resetDefaults() {
        maxLengthForSingleLineDescription = 80;
        maxElementsForPrinting = 1000;
    }

    public static void setMaxLengthForSingleLineDescription(int value) {
        Preconditions.checkArgument(value > 0, "maxLengthForSingleLineDescription must be > 0 but was %s", value);
        maxLengthForSingleLineDescription = value;
    }

    public static int getMaxLengthForSingleLineDescription() {
        return maxLengthForSingleLineDescription;
    }

    public static void setMaxElementsForPrinting(int value) {
        Preconditions.checkArgument(value >= 1, "maxElementsForPrinting must be >= 1, but was %s", value);
        maxElementsForPrinting = value;
    }

    public static <T> void registerFormatterForType(Class<T> type, Function<T, String> formatter) {
        customFormatterByType.put(type, formatter);
    }

    public static void removeAllRegisteredFormatters() {
        customFormatterByType.clear();
    }

    @Override
    public String toStringOf(Object object) {
        if (object == null) {
            return null;
        }
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof Calendar) {
            return this.toStringOf((Calendar)object);
        }
        if (object instanceof Class) {
            return this.toStringOf((Class)object);
        }
        if (object instanceof Date) {
            return this.toStringOf((Date)object);
        }
        if (object instanceof AtomicBoolean) {
            return this.toStringOf((AtomicBoolean)object);
        }
        if (object instanceof AtomicInteger) {
            return this.toStringOf((AtomicInteger)object);
        }
        if (object instanceof AtomicLong) {
            return this.toStringOf((AtomicLong)object);
        }
        if (object instanceof AtomicReference) {
            return this.toStringOf((AtomicReference)object);
        }
        if (object instanceof AtomicMarkableReference) {
            return this.toStringOf((AtomicMarkableReference)object);
        }
        if (object instanceof AtomicStampedReference) {
            return this.toStringOf((AtomicStampedReference)object);
        }
        if (object instanceof AtomicIntegerFieldUpdater) {
            return AtomicIntegerFieldUpdater.class.getSimpleName();
        }
        if (object instanceof AtomicLongFieldUpdater) {
            return AtomicLongFieldUpdater.class.getSimpleName();
        }
        if (object instanceof AtomicReferenceFieldUpdater) {
            return AtomicReferenceFieldUpdater.class.getSimpleName();
        }
        if (object instanceof Number) {
            return this.toStringOf((Number)object);
        }
        if (object instanceof File) {
            return this.toStringOf((File)object);
        }
        if (object instanceof String) {
            return this.toStringOf((String)object);
        }
        if (object instanceof Character) {
            return this.toStringOf((Character)object);
        }
        if (object instanceof Comparator) {
            return this.toStringOf((Comparator)object);
        }
        if (object instanceof SimpleDateFormat) {
            return this.toStringOf((SimpleDateFormat)object);
        }
        if (object instanceof PredicateDescription) {
            return this.toStringOf((PredicateDescription)object);
        }
        if (object instanceof CompletableFuture) {
            return this.toStringOf((CompletableFuture)object);
        }
        if (Arrays.isArray(object)) {
            return this.formatArray(object);
        }
        if (object instanceof Collection) {
            return this.smartFormat((Collection)object);
        }
        if (object instanceof Map) {
            return this.toStringOf((Map)object);
        }
        if (object instanceof Tuple) {
            return this.toStringOf((Tuple)object);
        }
        if (object instanceof MapEntry) {
            return this.toStringOf((MapEntry)object);
        }
        if (object instanceof Method) {
            return ((Method)object).toGenericString();
        }
        if (object instanceof InsertDelta) {
            return this.toStringOf((InsertDelta)object);
        }
        if (object instanceof ChangeDelta) {
            return this.toStringOf((ChangeDelta)object);
        }
        if (object instanceof DeleteDelta) {
            return this.toStringOf((DeleteDelta)object);
        }
        return object == null ? null : this.fallbackToStringOf(object);
    }

    protected <T> String customFormat(T object) {
        if (object == null) {
            return null;
        }
        return customFormatterByType.get(object.getClass()).apply(object);
    }

    protected boolean hasCustomFormatterFor(Object object) {
        if (object == null) {
            return false;
        }
        return customFormatterByType.containsKey(object.getClass());
    }

    @Override
    public String unambiguousToStringOf(Object obj) {
        return obj == null ? null : String.format("%s (%s@%s)", this.toStringOf(obj), obj.getClass().getSimpleName(), Integer.toHexString(obj.hashCode()));
    }

    protected String fallbackToStringOf(Object object) {
        return object.toString();
    }

    protected String toStringOf(Number number) {
        if (number instanceof Float) {
            return this.toStringOf((Float)number);
        }
        if (number instanceof Long) {
            return this.toStringOf((Long)number);
        }
        return number.toString();
    }

    protected String toStringOf(AtomicBoolean atomicBoolean) {
        return String.format("AtomicBoolean(%s)", atomicBoolean.get());
    }

    protected String toStringOf(AtomicInteger atomicInteger) {
        return String.format("AtomicInteger(%s)", atomicInteger.get());
    }

    protected String toStringOf(AtomicLong atomicLong) {
        return String.format("AtomicLong(%s)", atomicLong.get());
    }

    protected String toStringOf(Comparator<?> comparator) {
        if (!comparator.toString().contains("@")) {
            return comparator.toString();
        }
        String comparatorSimpleClassName = comparator.getClass().getSimpleName();
        if (comparatorSimpleClassName.length() == 0) {
            return Strings.quote("anonymous comparator class");
        }
        if (comparator.toString().contains(comparatorSimpleClassName + "@")) {
            return comparatorSimpleClassName;
        }
        return comparator.toString();
    }

    protected String toStringOf(Calendar c) {
        return DateUtil.formatAsDatetime(c);
    }

    protected String toStringOf(Class<?> c) {
        return c.getCanonicalName();
    }

    protected String toStringOf(String s) {
        return Strings.concat("\"", s, "\"");
    }

    protected String toStringOf(Character c) {
        return Strings.concat("'", c, "'");
    }

    protected String toStringOf(PredicateDescription p) {
        return p.isDefault() ? String.format("%s", p.description) : String.format("'%s'", p.description);
    }

    protected String toStringOf(Date d) {
        return DateUtil.formatAsDatetimeWithMs(d);
    }

    protected String toStringOf(Float f) {
        return String.format("%sf", f);
    }

    protected String toStringOf(Long l) {
        return String.format("%sL", l);
    }

    protected String toStringOf(File f) {
        return f.getAbsolutePath();
    }

    protected String toStringOf(SimpleDateFormat dateFormat) {
        return dateFormat.toPattern();
    }

    protected String toStringOf(CompletableFuture<?> future) {
        String className = future.getClass().getSimpleName();
        if (!future.isDone()) {
            return Strings.concat(className, "[Incomplete]");
        }
        try {
            Object joinResult = future.join();
            Object joinResultRepresentation = joinResult instanceof CompletableFuture ? joinResult : this.toStringOf(joinResult);
            return Strings.concat(className, "[Completed: ", joinResultRepresentation, DEFAULT_END);
        }
        catch (CompletionException e) {
            return Strings.concat(className, "[Failed: ", this.toStringOf(e.getCause()), DEFAULT_END);
        }
        catch (CancellationException e) {
            return Strings.concat(className, "[Cancelled]");
        }
    }

    protected String toStringOf(Tuple tuple) {
        return this.singleLineFormat(tuple.toList(), TUPLE_START, TUPLE_END);
    }

    protected String toStringOf(MapEntry<?, ?> mapEntry) {
        return String.format("MapEntry[key=%s, value=%s]", this.toStringOf(mapEntry.key), this.toStringOf(mapEntry.value));
    }

    protected String toStringOf(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Map<?, ?> sortedMap = StandardRepresentation.toSortedMapIfPossible(map);
        Iterator<Map.Entry<?, ?>> entriesIterator = sortedMap.entrySet().iterator();
        if (!entriesIterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        int printedElements = 0;
        while (true) {
            Map.Entry<?, ?> entry = entriesIterator.next();
            if (printedElements == maxElementsForPrinting) {
                builder.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
                return builder.append("}").toString();
            }
            builder.append(this.format(map, entry.getKey())).append('=').append(this.format(map, entry.getValue()));
            ++printedElements;
            if (!entriesIterator.hasNext()) {
                return builder.append("}").toString();
            }
            builder.append(", ");
        }
    }

    private static Map<?, ?> toSortedMapIfPossible(Map<?, ?> map) {
        try {
            return new TreeMap(map);
        }
        catch (ClassCastException | NullPointerException e) {
            return map;
        }
    }

    private String format(Map<?, ?> map, Object o) {
        return o == map ? "(this Map)" : this.toStringOf(o);
    }

    protected String toStringOf(AtomicReference<?> atomicReference) {
        return String.format("AtomicReference[%s]", this.toStringOf(atomicReference.get()));
    }

    protected String toStringOf(AtomicMarkableReference<?> atomicMarkableReference) {
        return String.format("AtomicMarkableReference[marked=%s, reference=%s]", atomicMarkableReference.isMarked(), this.toStringOf(atomicMarkableReference.getReference()));
    }

    protected String toStringOf(AtomicStampedReference<?> atomicStampedReference) {
        return String.format("AtomicStampedReference[stamp=%s, reference=%s]", atomicStampedReference.getStamp(), this.toStringOf(atomicStampedReference.getReference()));
    }

    private String toStringOf(ChangeDelta<?> changeDelta) {
        return String.format("Changed content at line %s:%nexpecting:%n  %s%nbut was:%n  %s%n", changeDelta.lineNumber(), this.formatLines(changeDelta.getOriginal().getLines()), this.formatLines(changeDelta.getRevised().getLines()));
    }

    private String toStringOf(DeleteDelta<?> deleteDelta) {
        return String.format("Missing content at line %s:%n  %s%n", deleteDelta.lineNumber(), this.formatLines(deleteDelta.getOriginal().getLines()));
    }

    private String toStringOf(InsertDelta<?> insertDelta) {
        return String.format("Extra content at line %s:%n  %s%n", insertDelta.lineNumber(), this.formatLines(insertDelta.getRevised().getLines()));
    }

    private String formatLines(List<?> lines) {
        return this.format(lines, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, "   ");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected String formatArray(Object o) {
        if (!Arrays.isArray(o)) {
            return null;
        }
        return Arrays.isObjectArray(o) ? this.smartFormat(this, (Object[])o) : this.formatPrimitiveArray(o);
    }

    protected String multiLineFormat(Representation representation, Object[] iterable, Set<Object[]> alreadyFormatted) {
        return this.format(iterable, ELEMENT_SEPARATOR_WITH_NEWLINE, INDENTATION_AFTER_NEWLINE, alreadyFormatted);
    }

    protected String singleLineFormat(Representation representation, Object[] iterable, String start, String end, Set<Object[]> alreadyFormatted) {
        return this.format(iterable, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE, alreadyFormatted);
    }

    protected String smartFormat(Representation representation, Object[] iterable) {
        HashSet<Object[]> alreadyFormatted = new HashSet<Object[]>();
        String singleLineDescription = this.singleLineFormat(representation, iterable, DEFAULT_START, DEFAULT_END, alreadyFormatted);
        return StandardRepresentation.doesDescriptionFitOnSingleLine(singleLineDescription) ? singleLineDescription : this.multiLineFormat(representation, iterable, alreadyFormatted);
    }

    protected String format(Object[] array, String elementSeparator, String indentation, Set<Object[]> alreadyFormatted) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder desc = new StringBuilder();
        desc.append(DEFAULT_START);
        alreadyFormatted.add(array);
        int i = 0;
        while (true) {
            Object element = array[i];
            if (i != 0) {
                desc.append(indentation);
            }
            if (i == maxElementsForPrinting) {
                desc.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
                alreadyFormatted.remove(array);
                return desc.append(DEFAULT_END).toString();
            }
            if (!Arrays.isArray(element)) {
                desc.append(element == null ? NULL : this.toStringOf(element));
            } else if (Arrays.isArrayTypePrimitive(element)) {
                desc.append(this.formatPrimitiveArray(element));
            } else if (alreadyFormatted.contains(element)) {
                desc.append("(this array)");
            } else {
                desc.append(this.format((Object[])element, elementSeparator, indentation, alreadyFormatted));
            }
            if (i == array.length - 1) {
                alreadyFormatted.remove(array);
                return desc.append(DEFAULT_END).toString();
            }
            desc.append(elementSeparator);
            ++i;
        }
    }

    protected String formatPrimitiveArray(Object o) {
        if (!Arrays.isArray(o)) {
            return null;
        }
        if (!Arrays.isArrayTypePrimitive(o)) {
            throw Arrays.notAnArrayOfPrimitives(o);
        }
        int size = Array.getLength(o);
        if (size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(DEFAULT_START);
        buffer.append(this.toStringOf(Array.get(o, 0)));
        for (int i = 1; i < size; ++i) {
            buffer.append(ELEMENT_SEPARATOR).append(INDENTATION_FOR_SINGLE_LINE);
            if (i == maxElementsForPrinting) {
                buffer.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
                break;
            }
            buffer.append(this.toStringOf(Array.get(o, i)));
        }
        buffer.append(DEFAULT_END);
        return buffer.toString();
    }

    public String format(Iterable<?> iterable, String start, String end, String elementSeparator, String indentation) {
        if (iterable == null) {
            return null;
        }
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return start + end;
        }
        StringBuilder desc = new StringBuilder(start);
        boolean firstElement = true;
        int printedElements = 0;
        while (true) {
            Object element = iterator.next();
            if (firstElement) {
                firstElement = false;
            } else {
                desc.append(indentation);
            }
            if (printedElements == maxElementsForPrinting) {
                desc.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
                return desc.append(end).toString();
            }
            desc.append(element == iterable ? "(this Collection)" : this.toStringOf(element));
            ++printedElements;
            if (!iterator.hasNext()) {
                return desc.append(end).toString();
            }
            desc.append(elementSeparator);
        }
    }

    protected String multiLineFormat(Iterable<?> iterable) {
        return this.format(iterable, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, INDENTATION_AFTER_NEWLINE);
    }

    protected String singleLineFormat(Iterable<?> iterable, String start, String end) {
        return this.format(iterable, start, end, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE);
    }

    protected String smartFormat(Iterable<?> iterable) {
        String singleLineDescription = this.singleLineFormat(iterable, DEFAULT_START, DEFAULT_END);
        return StandardRepresentation.doesDescriptionFitOnSingleLine(singleLineDescription) ? singleLineDescription : this.multiLineFormat(iterable);
    }

    private static boolean doesDescriptionFitOnSingleLine(String singleLineDescription) {
        return singleLineDescription == null || singleLineDescription.length() < maxLengthForSingleLineDescription;
    }
}

