/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive;

import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.Assigner;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveWideningDelegate;

public class PrimitiveTypeAwareAssigner
implements Assigner {
    private final Assigner referenceTypeAwareAssigner;

    public PrimitiveTypeAwareAssigner(Assigner referenceTypeAwareAssigner) {
        this.referenceTypeAwareAssigner = referenceTypeAwareAssigner;
    }

    @Override
    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source.isPrimitive() && target.isPrimitive()) {
            return PrimitiveWideningDelegate.forPrimitive(source).widenTo(target);
        }
        if (source.isPrimitive()) {
            return PrimitiveBoxingDelegate.forPrimitive(source).assignBoxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        if (target.isPrimitive()) {
            return PrimitiveUnboxingDelegate.forReferenceType(source).assignUnboxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        return this.referenceTypeAwareAssigner.assign(source, target, typing);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveTypeAwareAssigner)) {
            return false;
        }
        PrimitiveTypeAwareAssigner other = (PrimitiveTypeAwareAssigner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Assigner this$referenceTypeAwareAssigner = this.referenceTypeAwareAssigner;
        Assigner other$referenceTypeAwareAssigner = other.referenceTypeAwareAssigner;
        return !(this$referenceTypeAwareAssigner == null ? other$referenceTypeAwareAssigner != null : !this$referenceTypeAwareAssigner.equals(other$referenceTypeAwareAssigner));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrimitiveTypeAwareAssigner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Assigner $referenceTypeAwareAssigner = this.referenceTypeAwareAssigner;
        result = result * 59 + ($referenceTypeAwareAssigner == null ? 43 : $referenceTypeAwareAssigner.hashCode());
        return result;
    }
}

