/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.ComparableAssert;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractComparableAssert<SELF extends AbstractComparableAssert<SELF, ACTUAL>, ACTUAL extends Comparable<? super ACTUAL>>
extends AbstractObjectAssert<SELF, ACTUAL>
implements ComparableAssert<SELF, ACTUAL> {
    @VisibleForTesting
    Comparables comparables = new Comparables();

    protected AbstractComparableAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public SELF isEqualByComparingTo(ACTUAL other) {
        this.comparables.assertEqualByComparison(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    public SELF isNotEqualByComparingTo(ACTUAL other) {
        this.comparables.assertNotEqualByComparison(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    public SELF isLessThan(ACTUAL other) {
        this.comparables.assertLessThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(ACTUAL other) {
        this.comparables.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(ACTUAL other) {
        this.comparables.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(ACTUAL other) {
        this.comparables.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    public SELF isBetween(ACTUAL startInclusive, ACTUAL endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(ACTUAL startExclusive, ACTUAL endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractComparableAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        this.comparables = new Comparables(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractComparableAssert)super.usingComparator((Comparator)customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.comparables = new Comparables();
        return (SELF)((AbstractComparableAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF inHexadecimal() {
        return (SELF)((AbstractComparableAssert)super.inHexadecimal());
    }

    @Override
    @CheckReturnValue
    public SELF inBinary() {
        return (SELF)((AbstractComparableAssert)super.inBinary());
    }
}

