/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.annotation.Annotation;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Classes;
import org.assertj.core.util.Arrays;

public abstract class AbstractClassAssert<SELF extends AbstractClassAssert<SELF>>
extends AbstractAssert<SELF, Class<?>> {
    Classes classes = Classes.instance();

    protected AbstractClassAssert(Class<?> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isAssignableFrom(Class<?> ... others) {
        this.classes.assertIsAssignableFrom(this.info, (Class)this.actual, others);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotInterface() {
        this.classes.assertIsNotInterface(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isInterface() {
        this.classes.assertIsInterface(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isAbstract() {
        this.classes.assertIsAbstract(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isAnnotation() {
        this.classes.assertIsAnnotation(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotAnnotation() {
        this.classes.assertIsNotAnnotation(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isFinal() {
        this.classes.assertIsFinal(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotFinal() {
        this.classes.assertIsNotFinal(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isPublic() {
        this.classes.assertIsPublic(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isProtected() {
        this.classes.assertIsProtected(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isPackagePrivate() {
        this.classes.assertIsPackagePrivate(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isStatic() {
        this.classes.assertIsStatic(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF isNotStatic() {
        this.classes.assertIsNotStatic(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    @SafeVarargs
    public final SELF hasAnnotations(Class<? extends Annotation> ... annotations) {
        return this.hasAnnotationsForProxy(annotations);
    }

    protected SELF hasAnnotationsForProxy(Class<? extends Annotation>[] annotations) {
        this.classes.assertContainsAnnotations(this.info, (Class)this.actual, annotations);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasAnnotation(Class<? extends Annotation> annotation) {
        this.classes.assertContainsAnnotations(this.info, (Class)this.actual, Arrays.array(annotation));
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasSuperclass(Class<?> superclass) {
        this.classes.assertHasSuperclass(this.info, (Class)this.actual, superclass);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasNoSuperclass() {
        this.classes.assertHasNoSuperclass(this.info, (Class)this.actual);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    @Deprecated
    public SELF hasFields(String ... fields) {
        return this.hasPublicFields(fields);
    }

    public SELF hasPublicFields(String ... fields) {
        this.classes.assertHasPublicFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasOnlyPublicFields(String ... fields) {
        this.classes.assertHasOnlyPublicFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasDeclaredFields(String ... fields) {
        this.classes.assertHasDeclaredFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasOnlyDeclaredFields(String ... fields) {
        this.classes.assertHasOnlyDeclaredFields(this.info, (Class)this.actual, fields);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasMethods(String ... methodNames) {
        this.classes.assertHasMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasDeclaredMethods(String ... methodNames) {
        this.classes.assertHasDeclaredMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasPublicMethods(String ... methodNames) {
        this.classes.assertHasPublicMethods(this.info, (Class)this.actual, methodNames);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasPackage(String packageName) {
        this.classes.assertHasPackage((AssertionInfo)this.info, (Class)this.actual, packageName);
        return (SELF)((AbstractClassAssert)this.myself);
    }

    public SELF hasPackage(Package aPackage) {
        this.classes.assertHasPackage((AssertionInfo)this.info, (Class)this.actual, aPackage);
        return (SELF)((AbstractClassAssert)this.myself);
    }
}

