/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeCloseTo;
import org.assertj.core.error.ShouldHaveDuration;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractDurationAssert<SELF extends AbstractDurationAssert<SELF>>
extends AbstractComparableAssert<SELF, Duration> {
    public AbstractDurationAssert(Duration duration, Class<?> selfType) {
        super(duration, selfType);
    }

    public SELF isZero() {
        this.isNotNull();
        return (SELF)((AbstractDurationAssert)this.isEqualTo(Duration.ZERO));
    }

    public SELF isNegative() {
        this.isNotNull();
        return (SELF)((AbstractDurationAssert)this.isLessThan(Duration.ZERO));
    }

    public SELF isPositive() {
        this.isNotNull();
        return (SELF)((AbstractDurationAssert)this.isGreaterThan(Duration.ZERO));
    }

    public SELF hasNanos(long otherNanos) {
        this.isNotNull();
        long actualNanos = ((Duration)this.actual).toNanos();
        if (otherNanos != actualNanos) {
            throw Failures.instance().failure(this.info, ShouldHaveDuration.shouldHaveNanos((Duration)this.actual, actualNanos, otherNanos), actualNanos, otherNanos);
        }
        return (SELF)((AbstractDurationAssert)this.myself);
    }

    public SELF hasMillis(long otherMillis) {
        this.isNotNull();
        long actualMillis = ((Duration)this.actual).toMillis();
        if (otherMillis != actualMillis) {
            throw Failures.instance().failure(this.info, ShouldHaveDuration.shouldHaveMillis((Duration)this.actual, actualMillis, otherMillis), actualMillis, otherMillis);
        }
        return (SELF)((AbstractDurationAssert)this.myself);
    }

    public SELF hasSeconds(long otherSeconds) {
        this.isNotNull();
        long actualSeconds = ((Duration)this.actual).getSeconds();
        if (otherSeconds != actualSeconds) {
            throw Failures.instance().failure(this.info, ShouldHaveDuration.shouldHaveSeconds((Duration)this.actual, actualSeconds, otherSeconds), actualSeconds, otherSeconds);
        }
        return (SELF)((AbstractDurationAssert)this.myself);
    }

    public SELF hasMinutes(long otherMinutes) {
        this.isNotNull();
        long actualMinutes = ((Duration)this.actual).toMinutes();
        if (otherMinutes != actualMinutes) {
            throw Failures.instance().failure(this.info, ShouldHaveDuration.shouldHaveMinutes((Duration)this.actual, actualMinutes, otherMinutes), actualMinutes, otherMinutes);
        }
        return (SELF)((AbstractDurationAssert)this.myself);
    }

    public SELF hasHours(long otherHours) {
        this.isNotNull();
        long actualHours = ((Duration)this.actual).toHours();
        if (otherHours != actualHours) {
            throw Failures.instance().failure(this.info, ShouldHaveDuration.shouldHaveHours((Duration)this.actual, actualHours, otherHours), actualHours, otherHours);
        }
        return (SELF)((AbstractDurationAssert)this.myself);
    }

    public SELF hasDays(long otherDays) {
        this.isNotNull();
        long actualDays = ((Duration)this.actual).toDays();
        if (otherDays != actualDays) {
            throw Failures.instance().failure(this.info, ShouldHaveDuration.shouldHaveDays((Duration)this.actual, actualDays, otherDays), actualDays, otherDays);
        }
        return (SELF)((AbstractDurationAssert)this.myself);
    }

    public SELF isCloseTo(Duration expected, Duration allowedDifference) {
        Objects.instance().assertNotNull(this.info, this.actual);
        Preconditions.checkArgument(expected != null, "expected duration should not be null", new Object[0]);
        Preconditions.checkArgument(allowedDifference != null, "allowed difference duration should not be null", new Object[0]);
        Preconditions.checkArgument(!allowedDifference.isNegative(), "allowed difference duration should be >= 0", new Object[0]);
        if (AbstractDurationAssert.absDiff((Duration)this.actual, expected).compareTo(allowedDifference) > 0) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeCloseTo.shouldBeCloseTo((TemporalAmount)this.actual, expected, allowedDifference, AbstractDurationAssert.absDiff((Duration)this.actual, expected)));
        }
        return (SELF)((AbstractDurationAssert)this.myself);
    }

    private static Duration absDiff(Duration actual, Duration expected) {
        return actual.minus(expected).abs();
    }
}

