/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ComparatorFactory;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.DoubleArrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDoubleArrayAssert<SELF extends AbstractDoubleArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, double[], Double> {
    @VisibleForTesting
    protected DoubleArrays arrays = DoubleArrays.instance();
    private final ComparatorFactory doubleComparator = ComparatorFactory.INSTANCE;

    public AbstractDoubleArrayAssert(double[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (double[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (double[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (double[])this.actual);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (double[])this.actual, expected);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int boundary) {
        this.arrays.assertHasSizeGreaterThan(this.info, (double[])this.actual, boundary);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(this.info, (double[])this.actual, boundary);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int boundary) {
        this.arrays.assertHasSizeLessThan(this.info, (double[])this.actual, boundary);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(this.info, (double[])this.actual, boundary);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(this.info, (double[])this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (double[])this.actual, other);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF contains(double ... values) {
        this.arrays.assertContains(this.info, (double[])this.actual, values);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF contains(double[] values, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).contains(values);
    }

    public SELF containsOnly(double ... values) {
        this.arrays.assertContainsOnly(this.info, (double[])this.actual, values);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsOnly(double[] values, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsOnly(values);
    }

    public SELF containsOnlyOnce(double ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (double[])this.actual, values);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(double[] values, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsOnlyOnce(values);
    }

    public SELF containsSequence(double ... sequence) {
        this.arrays.assertContainsSequence(this.info, (double[])this.actual, sequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsSequence(double[] sequence, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsSequence(sequence);
    }

    public SELF containsSubsequence(double ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (double[])this.actual, subsequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsSubsequence(double[] subsequence, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsSubsequence(subsequence);
    }

    public SELF contains(double value, Index index) {
        this.arrays.assertContains(this.info, (double[])this.actual, value, index);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF contains(double value, Index index, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).contains(value, index);
    }

    public SELF doesNotContain(double ... values) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, values);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF doesNotContain(double[] values, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).doesNotContain(values);
    }

    public SELF doesNotContain(double value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (double[])this.actual, value, index);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF doesNotContain(double value, Index index, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).doesNotContain(value, index);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (double[])this.actual);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates(Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).doesNotHaveDuplicates();
    }

    public SELF startsWith(double ... sequence) {
        this.arrays.assertStartsWith(this.info, (double[])this.actual, sequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF startsWith(double[] values, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).startsWith(values);
    }

    public SELF endsWith(double ... sequence) {
        this.arrays.assertEndsWith(this.info, (double[])this.actual, sequence);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF endsWith(double[] values, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).endsWith(values);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (double[])this.actual);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Double> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (double[])this.actual, comparator);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Double> customComparator) {
        this.arrays = new DoubleArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = DoubleArrays.instance();
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsExactly(double ... values) {
        this.arrays.assertContainsExactly(this.info, (double[])this.actual, values);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(double ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (double[])this.actual, values);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }

    public SELF containsExactly(double[] values, Offset<Double> precision) {
        return ((AbstractDoubleArrayAssert)this.usingComparatorWithPrecision((Double)precision.value)).containsExactly(values);
    }

    @CheckReturnValue
    public SELF usingComparatorWithPrecision(Double precision) {
        return (SELF)this.usingElementComparator(this.doubleComparator.doubleComparatorWithPrecision(precision));
    }

    public SELF containsAnyOf(double ... values) {
        this.arrays.assertContainsAnyOf(this.info, (double[])this.actual, values);
        return (SELF)((AbstractDoubleArrayAssert)this.myself);
    }
}

