/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.parquet.Log;
import org.slf4j.bridge.SLF4JBridgeHandler;

final class ParquetLogRedirector
implements Serializable {
    static final ParquetLogRedirector INSTANCE = new ParquetLogRedirector();
    private static final Logger apacheParquetLogger = Logger.getLogger(Log.class.getPackage().getName());
    private static final Logger parquetLogger = Logger.getLogger("parquet");

    private ParquetLogRedirector() {
    }

    private static void redirect(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        logger.setUseParentHandlers(false);
        logger.addHandler((Handler)new SLF4JBridgeHandler());
    }

    static {
        try {
            Class.forName(Log.class.getName());
            ParquetLogRedirector.redirect(Logger.getLogger(Log.class.getPackage().getName()));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        try {
            Class.forName("parquet.Log");
            ParquetLogRedirector.redirect(Logger.getLogger("parquet"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

