/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class PartitioningUtils$ {
    public static final PartitioningUtils$ MODULE$;
    private final Seq<DataType> org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder;

    static {
        new PartitioningUtils$();
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, boolean typeInference, Set<Path> basePaths2) {
        Tuple2 tuple2;
        block2: {
            PartitioningUtils.PartitionValues partitionValues;
            block5: {
                PartitionSpec partitionSpec2;
                block4: {
                    Tuple2 tuple22;
                    Seq pathsWithPartitionValues;
                    Seq optDiscoveredBasePaths;
                    block3: {
                        Tuple2 tuple23;
                        tuple2 = ((GenericTraversableTemplate)paths.map((Function1)new Serializable(typeInference, basePaths2){
                            public static final long serialVersionUID = 0L;
                            private final boolean typeInference$1;
                            private final Set basePaths$1;

                            public final Tuple2<Option<PartitioningUtils.PartitionValues>, Option<Path>> apply(Path path) {
                                return PartitioningUtils$.MODULE$.parsePartition(path, this.typeInference$1, (Set<Path>)this.basePaths$1);
                            }
                            {
                                this.typeInference$1 = typeInference$1;
                                this.basePaths$1 = basePaths$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                        if (tuple2 == null) break block2;
                        Seq partitionValues2 = (Seq)tuple2._1();
                        Seq optDiscoveredBasePaths2 = (Seq)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)partitionValues2, (Object)optDiscoveredBasePaths2);
                        Seq partitionValues3 = (Seq)tuple24._1();
                        optDiscoveredBasePaths = (Seq)tuple24._2();
                        pathsWithPartitionValues = (Seq)((TraversableLike)paths.zip((GenIterable)partitionValues3, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<Tuple2<Path, PartitioningUtils.PartitionValues>> apply(Tuple2<Path, Option<PartitioningUtils.PartitionValues>> x) {
                                return Option$.MODULE$.option2Iterable(((Option)x._2()).map((Function1)new Serializable(this, x){
                                    public static final long serialVersionUID = 0L;
                                    private final Tuple2 x$26;

                                    public final Tuple2<Path, PartitioningUtils.PartitionValues> apply(PartitioningUtils.PartitionValues x$2) {
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.x$26._1()), (Object)x$2);
                                    }
                                    {
                                        this.x$26 = x$26;
                                    }
                                }));
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        if (!pathsWithPartitionValues.isEmpty()) break block3;
                        partitionSpec2 = PartitionSpec$.MODULE$.emptySpec();
                        break block4;
                    }
                    Seq discoveredBasePaths = (Seq)((TraversableLike)optDiscoveredBasePaths.flatten((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Iterable<Path> apply(Option<Path> xo) {
                            return Option$.MODULE$.option2Iterable(xo);
                        }
                    })).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Path x$3) {
                            return x$3.toString().toLowerCase();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Predef$.MODULE$.assert(((SeqLike)discoveredBasePaths.distinct()).size() == 1, (Function0)new Serializable(discoveredBasePaths){
                        public static final long serialVersionUID = 0L;
                        private final Seq discoveredBasePaths$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Conflicting directory structures detected. Suspicious paths:\b").append((Object)((TraversableOnce)this.discoveredBasePaths$1.distinct()).mkString("\n\t", "\n\t", "\n\n")).append((Object)"If provided paths are partition directories, please set ").append((Object)"\"basePath\" in the options of the data source to specify the ").append((Object)"root directory of the table. If there are multiple root directories, ").append((Object)"please load them separately and then union them.").toString();
                        }
                        {
                            this.discoveredBasePaths$1 = discoveredBasePaths$1;
                        }
                    });
                    Seq<PartitioningUtils.PartitionValues> resolvedPartitionValues = this.resolvePartitions((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)pathsWithPartitionValues);
                    partitionValues = (PartitioningUtils.PartitionValues)resolvedPartitionValues.head();
                    if (partitionValues == null) break block5;
                    Seq<String> columnNames = partitionValues.columnNames();
                    Seq<Literal> literals = partitionValues.literals();
                    Tuple2 tuple25 = tuple22 = new Tuple2(columnNames, literals);
                    Seq columnNames2 = (Seq)tuple25._1();
                    Seq literals2 = (Seq)tuple25._2();
                    Seq fields = (Seq)((TraversableLike)columnNames2.zip((GenIterable)literals2, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final StructField apply(Tuple2<String, Literal> x0$1) {
                            Tuple2<String, Literal> tuple2 = x0$1;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Literal literal = (Literal)tuple2._2();
                                if (literal != null) {
                                    DataType dataType = literal.dataType();
                                    StructField structField = new StructField(name, dataType, true, StructField$.MODULE$.apply$default$4());
                                    return structField;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq partitions = (Seq)((TraversableLike)resolvedPartitionValues.zip((GenIterable)pathsWithPartitionValues, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final PartitionPath apply(Tuple2<PartitioningUtils.PartitionValues, Tuple2<Path, PartitioningUtils.PartitionValues>> x0$2) {
                            Tuple2<PartitioningUtils.PartitionValues, Tuple2<Path, PartitioningUtils.PartitionValues>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                PartitioningUtils.PartitionValues partitionValues = (PartitioningUtils.PartitionValues)tuple2._1();
                                Tuple2 tuple22 = (Tuple2)tuple2._2();
                                if (partitionValues != null) {
                                    Seq<Literal> literals = partitionValues.literals();
                                    if (tuple22 != null) {
                                        Path path = (Path)tuple22._1();
                                        PartitionPath partitionPath = new PartitionPath(InternalRow$.MODULE$.fromSeq((Seq)literals.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Object apply(Literal x$5) {
                                                return x$5.value();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())), path);
                                        return partitionPath;
                                    }
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    partitionSpec2 = new PartitionSpec(StructType$.MODULE$.apply(fields), (Seq<PartitionPath>)partitions);
                }
                return partitionSpec2;
            }
            throw new MatchError((Object)partitionValues);
        }
        throw new MatchError((Object)tuple2);
    }

    public Tuple2<Option<PartitioningUtils.PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths2) {
        ArrayBuffer columns2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (true) {
            block6: {
                Tuple2 tuple2;
                block9: {
                    Tuple2 tuple22;
                    block8: {
                        Tuple2 tuple23;
                        block7: {
                            if (!finished) break block6;
                            if (!columns2.isEmpty()) break block7;
                            tuple22 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
                            break block8;
                        }
                        tuple2 = ((GenericTraversableTemplate)columns2.reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
                        if (tuple2 == null) break block9;
                        ArrayBuffer columnNames = (ArrayBuffer)tuple2._1();
                        ArrayBuffer values = (ArrayBuffer)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)columnNames, (Object)values);
                        ArrayBuffer columnNames2 = (ArrayBuffer)tuple24._1();
                        ArrayBuffer values2 = (ArrayBuffer)tuple24._2();
                        tuple22 = new Tuple2((Object)new Some((Object)new PartitioningUtils.PartitionValues((Seq<String>)columnNames2, (Seq<Literal>)values2)), (Object)new Some((Object)currentPath));
                    }
                    return tuple22;
                }
                throw new MatchError((Object)tuple2);
            }
            String string = currentPath.getName().toLowerCase();
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths2.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, Literal>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference);
            maybeColumn.foreach((Function1)new Serializable(columns2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer columns$1;

                public final ArrayBuffer<Tuple2<String, Literal>> apply(Tuple2<String, Literal> x$6) {
                    return this.columns$1.$plus$eq(x$6);
                }
                {
                    this.columns$1 = columns$1;
                }
            });
            finished = maybeColumn.isEmpty() && !columns2.isEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
    }

    private Option<Tuple2<String, Literal>> parsePartitionColumn(String columnSpec, boolean typeInference) {
        None$ none$;
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            none$ = None$.MODULE$;
        } else {
            String columnName = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).take(equalSignIndex);
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(columnName)).nonEmpty(), (Function0)new Serializable(columnSpec){
                public static final long serialVersionUID = 0L;
                private final String columnSpec$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty partition column name in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnSpec$1}));
                }
                {
                    this.columnSpec$1 = columnSpec$1;
                }
            });
            String rawColumnValue = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).drop(equalSignIndex + 1);
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(rawColumnValue)).nonEmpty(), (Function0)new Serializable(columnSpec){
                public static final long serialVersionUID = 0L;
                private final String columnSpec$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty partition column value in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnSpec$1}));
                }
                {
                    this.columnSpec$1 = columnSpec$1;
                }
            });
            Literal literal = this.inferPartitionColumnValue(rawColumnValue, typeInference);
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)literal));
        }
        return none$;
    }

    public Map<String, String> parsePathFragment(String pathFragment) {
        return this.parsePathFragmentAsSeq(pathFragment).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<String, String>> parsePathFragmentAsSeq(String pathFragment) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])pathFragment.split("/")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String kv) {
                String[] pair = kv.split("=", 2);
                return new Tuple2((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[0]), (Object)ExternalCatalogUtils$.MODULE$.unescapePathName(pair[1]));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public String getPathFragment(Map<String, String> spec, StructType partitionSchema) {
        return ((TraversableOnce)partitionSchema.map((Function1)new Serializable(spec){
            public static final long serialVersionUID = 0L;
            private final Map spec$1;

            public final String apply(StructField field) {
                return new StringBuilder().append((Object)ExternalCatalogUtils$.MODULE$.escapePathName(field.name())).append((Object)"=").append((Object)ExternalCatalogUtils$.MODULE$.escapePathName((String)this.spec$1.apply((Object)field.name()))).toString();
            }
            {
                this.spec$1 = spec$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public <T> Map<String, T> normalizePartitionSpec(Map<String, T> partitionSpec2, Seq<String> partColNames, String tblName, Function2<String, String, Object> resolver) {
        Seq normalizedPartSpec = (Seq)partitionSpec2.toSeq().map((Function1)new Serializable(partColNames, tblName, resolver){
            public static final long serialVersionUID = 0L;
            private final Seq partColNames$1;
            public final String tblName$1;
            public final Function2 resolver$1;

            public final Tuple2<String, T> apply(Tuple2<String, T> x0$3) {
                Tuple2<String, T> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    String normalizedKey = (String)this.partColNames$1.find((Function1)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;
                        private final String key$1;

                        public final boolean apply(String x$8) {
                            return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)x$8, (Object)this.key$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;
                        private final String key$1;

                        public final Nothing$ apply() {
                            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a valid partition column in table ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.$outer.tblName$1})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)normalizedKey), value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.partColNames$1 = partColNames$1;
                this.tblName$1 = tblName$1;
                this.resolver$1 = resolver$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)((SeqLike)normalizedPartSpec.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, T> x$9) {
                return (String)x$9._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct()).length() != normalizedPartSpec.length()) {
            scala.collection.immutable.Iterable duplicateColumns = (scala.collection.immutable.Iterable)((TraversableLike)normalizedPartSpec.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, T> x$10) {
                    return (String)x$10._1();
                }
            }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return (String)Predef$.MODULE$.identity((Object)x);
                }
            }).collect((PartialFunction)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = x;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found duplicated columns in partition specification: "})).s((Seq)Nil$.MODULE$)).append((Object)duplicateColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return normalizedPartSpec.toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<PartitioningUtils.PartitionValues> resolvePartitions(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathsWithPartitionValues) {
        Seq seq;
        if (pathsWithPartitionValues.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq distinctPartColNames = (Seq)((SeqLike)pathsWithPartitionValues.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$11) {
                    return (Seq)((PartitioningUtils.PartitionValues)x$11._2()).columnNames().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$12) {
                            return x$12.toLowerCase();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
            }, Seq$.MODULE$.canBuildFrom())).distinct();
            Predef$.MODULE$.assert(distinctPartColNames.size() == 1, (Function0)new Serializable(pathsWithPartitionValues){
                public static final long serialVersionUID = 0L;
                private final Seq pathsWithPartitionValues$1;

                public final String apply() {
                    return PartitioningUtils$.MODULE$.listConflictingPartitionColumns((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)this.pathsWithPartitionValues$1);
                }
                {
                    this.pathsWithPartitionValues$1 = pathsWithPartitionValues$1;
                }
            });
            Seq values = (Seq)pathsWithPartitionValues.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final PartitioningUtils.PartitionValues apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$13) {
                    return (PartitioningUtils.PartitionValues)x$13._2();
                }
            }, Seq$.MODULE$.canBuildFrom());
            int columnCount = ((PartitioningUtils.PartitionValues)values.head()).columnNames().size();
            IndexedSeq resolvedValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1)new Serializable(values){
                public static final long serialVersionUID = 0L;
                private final Seq values$1;

                public final Seq<Literal> apply(int i) {
                    return PartitioningUtils$.MODULE$.org$apache$spark$sql$execution$datasources$PartitioningUtils$$resolveTypeConflicts((Seq<Literal>)((Seq)this.values$1.map((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final int i$1;

                        public final Literal apply(PartitioningUtils.PartitionValues x$14) {
                            return (Literal)x$14.literals().apply(this.i$1);
                        }
                        {
                            this.i$1 = i$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())));
                }
                {
                    this.values$1 = values$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            seq = (Seq)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(resolvedValues){
                public static final long serialVersionUID = 0L;
                private final IndexedSeq resolvedValues$1;

                public final PartitioningUtils.PartitionValues apply(Tuple2<PartitioningUtils.PartitionValues, Object> x0$4) {
                    Tuple2<PartitioningUtils.PartitionValues, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        PartitioningUtils.PartitionValues d = (PartitioningUtils.PartitionValues)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Seq x$23 = (Seq)this.resolvedValues$1.map((Function1)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final Literal apply(Seq<Literal> x$15) {
                                return (Literal)x$15.apply(this.index$1);
                            }
                            {
                                this.index$1 = index$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        Seq<String> x$24 = d.copy$default$1();
                        PartitioningUtils.PartitionValues partitionValues = d.copy(x$24, (Seq<Literal>)x$23);
                        return partitionValues;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.resolvedValues$1 = resolvedValues$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public String listConflictingPartitionColumns(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathWithPartitionValues) {
        Seq distinctPartColNames = (Seq)((SeqLike)pathWithPartitionValues.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$16) {
                return ((PartitioningUtils.PartitionValues)x$16._2()).columnNames();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        Map partColNamesToPaths = this.groupByKey$1((Seq)pathWithPartitionValues.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Seq<String>, Path> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x0$7) {
                Tuple2<Path, PartitioningUtils.PartitionValues> tuple2 = x0$7;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    PartitioningUtils.PartitionValues partValues = (PartitioningUtils.PartitionValues)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partValues.columnNames()), (Object)path);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq distinctPartColLists = (Seq)((TraversableLike)((IterableLike)distinctPartColNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<String> x$18) {
                return x$18.mkString(", ");
            }
        }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$8) {
                Tuple2<String, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    String names = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column name list #", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), names}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq suspiciousPaths = (Seq)((TraversableLike)distinctPartColNames.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<String> x$19) {
                return x$19.length();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)partColNamesToPaths, Seq$.MODULE$.canBuildFrom());
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conflicting partition column names detected:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)distinctPartColLists.mkString("\n\t", "\n\t", "\n\n")).append((Object)"For partitioned table directories, data files should only live in leaf directories.\n").append((Object)"And directories at the same level should have the same partition column name.\n").append((Object)"Please check the following directories for unexpected files or ").append((Object)"inconsistent partition column names:\n").append((Object)((TraversableOnce)suspiciousPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$20) {
                return new StringBuilder().append((Object)"\t").append((Object)x$20).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "")).toString();
    }

    public Literal inferPartitionColumnValue(String raw, boolean typeInference) {
        Literal literal;
        Try decimalTry = Try$.MODULE$.apply((Function0)new Serializable(raw){
            public static final long serialVersionUID = 0L;
            private final String raw$1;

            public final Literal apply() {
                BigDecimal bigDecimal = new BigDecimal(this.raw$1);
                Predef$.MODULE$.require(bigDecimal.scale() <= 0);
                return Literal$.MODULE$.apply((Object)bigDecimal);
            }
            {
                this.raw$1 = raw$1;
            }
        });
        if (typeInference) {
            literal = (Literal)Try$.MODULE$.apply((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                private final String raw$1;

                public final Literal apply() {
                    return Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(this.raw$1)), (DataType)IntegerType$.MODULE$);
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.2 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)Long.parseLong(this.$outer.raw$1)), (DataType)LongType$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(decimalTry){
                public static final long serialVersionUID = 0L;
                private final Try decimalTry$1;

                public final Try<Literal> apply() {
                    return this.decimalTry$1;
                }
                {
                    this.decimalTry$1 = decimalTry$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.4 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)Double.parseDouble(this.$outer.raw$1)), (DataType)DoubleType$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.5 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.apply((Object)Date.valueOf(this.$outer.raw$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.6 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.apply((Object)Timestamp.valueOf(ExternalCatalogUtils$.MODULE$.unescapePathName(this.$outer.raw$1)));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).getOrElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                private final String raw$1;

                public final Literal apply() {
                    String string = this.raw$1;
                    String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
                    return !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(this.raw$1), (DataType)StringType$.MODULE$);
                }
                {
                    this.raw$1 = raw$1;
                }
            });
        } else {
            String string = raw;
            String string2 = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
            literal = !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(raw), (DataType)StringType$.MODULE$);
        }
        return literal;
    }

    public Seq<DataType> org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder() {
        return this.org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder;
    }

    public void validatePartitionColumn(StructType schema, Seq<String> partitionColumns, boolean caseSensitive) {
        this.partitionColumnsSchema(schema, partitionColumns, caseSensitive).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StructField field) {
                DataType dataType = field.dataType();
                if (dataType instanceof AtomicType) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot use ", " for partition column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.dataType()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
        if (partitionColumns.nonEmpty() && partitionColumns.size() == schema.fields().length) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot use all columns for partition columns"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public StructType partitionColumnsSchema(StructType schema, Seq<String> partitionColumns, boolean caseSensitive) {
        Function2<String, String, Object> equality = this.columnNameEquality(caseSensitive);
        return StructType$.MODULE$.apply((Seq)partitionColumns.map((Function1)new Serializable(schema, equality){
            public static final long serialVersionUID = 0L;
            public final StructType schema$1;
            public final Function2 equality$1;

            public final StructField apply(String col) {
                return (StructField)this.schema$1.find((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionColumnsSchema.1 $outer;
                    private final String col$1;

                    public final boolean apply(StructField f) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.equality$1.apply((Object)f.name(), (Object)this.col$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                }).getOrElse((Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionColumnsSchema.1 $outer;
                    private final String col$1;

                    public final Nothing$ apply() {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column ", " not found in schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1, this.$outer.schema$1})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                });
            }
            {
                this.schema$1 = schema$1;
                this.equality$1 = equality$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).asNullable();
    }

    private Function2<String, String, Object> columnNameEquality(boolean caseSensitive) {
        return caseSensitive ? package$.MODULE$.caseSensitiveResolution() : package$.MODULE$.caseInsensitiveResolution();
    }

    public Seq<Literal> org$apache$spark$sql$execution$datasources$PartitioningUtils$$resolveTypeConflicts(Seq<Literal> literals) {
        DataType topType;
        DataType dataType = topType = (DataType)((TraversableOnce)literals.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Literal x$21) {
                return x$21.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom())).maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(DataType x$22) {
                return PartitioningUtils$.MODULE$.org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder().indexOf((Object)x$22);
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        NullType$ nullType$ = NullType$.MODULE$;
        StringType$ desiredType = !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null) ? StringType$.MODULE$ : topType;
        return (Seq)literals.map((Function1)new Serializable((DataType)desiredType){
            public static final long serialVersionUID = 0L;
            private final DataType desiredType$1;

            public final Literal apply(Literal x0$9) {
                Literal literal = x0$9;
                if (literal != null) {
                    Cast qual$1 = new Cast((Expression)literal, this.desiredType$1);
                    InternalRow x$25 = qual$1.eval$default$1();
                    Literal literal2 = Literal$.MODULE$.create(qual$1.eval(x$25), this.desiredType$1);
                    return literal2;
                }
                throw new MatchError((Object)literal);
            }
            {
                this.desiredType$1 = desiredType$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Map groupByKey$1(Seq seq) {
        return seq.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final K apply(Tuple2<K, V> x0$5) {
                Tuple2<K, V> tuple2 = x0$5;
                if (tuple2 != null) {
                    Object key;
                    Object object = key = tuple2._1();
                    return (K)object;
                }
                throw new MatchError(tuple2);
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<V> apply(Seq<Tuple2<K, V>> x$17) {
                return (Iterable)x$17.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final V apply(Tuple2<K, V> x0$6) {
                        Tuple2<K, V> tuple2 = x0$6;
                        if (tuple2 != null) {
                            Object value;
                            Object object = value = tuple2._2();
                            return (V)object;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        });
    }

    private PartitioningUtils$() {
        MODULE$ = this;
        this.org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{NullType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$}));
    }
}

