/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.concurrent;

import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@IgnoreJRERequirement
final class JreDoubleAdder implements DoubleAdder {

  private final java.util.concurrent.atomic.DoubleAdder delegate;

  JreDoubleAdder() {
    delegate = new java.util.concurrent.atomic.DoubleAdder();
  }

  @Override
  public void add(double x) {
    delegate.add(x);
  }

  @Override
  public double sum() {
    return delegate.sum();
  }

  @Override
  public void reset() {
    delegate.reset();
  }

  @Override
  public double sumThenReset() {
    return delegate.sumThenReset();
  }

  @Override
  public String toString() {
    return delegate.toString();
  }
}
