/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.util.List;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoSchemaConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoSchemaConverter.class);
    private final boolean parquetSpecsCompliant;

    public ProtoSchemaConverter() {
        this(false);
    }

    public ProtoSchemaConverter(boolean parquetSpecsCompliant) {
        this.parquetSpecsCompliant = parquetSpecsCompliant;
    }

    public MessageType convert(Class<? extends Message> protobufClass) {
        LOG.debug("Converting protocol buffer class \"" + protobufClass + "\" to parquet schema.");
        Descriptors.Descriptor descriptor = Protobufs.getMessageDescriptor(protobufClass);
        MessageType messageType = (MessageType)this.convertFields((Types.GroupBuilder)Types.buildMessage(), descriptor.getFields()).named(descriptor.getFullName());
        LOG.debug("Converter info:\n " + descriptor.toProto() + " was converted to \n" + messageType);
        return messageType;
    }

    private <T> Types.GroupBuilder<T> convertFields(Types.GroupBuilder<T> groupBuilder, List<Descriptors.FieldDescriptor> fieldDescriptors) {
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
            groupBuilder = (Types.GroupBuilder)this.addField(fieldDescriptor, groupBuilder).id(fieldDescriptor.getNumber()).named(fieldDescriptor.getName());
        }
        return groupBuilder;
    }

    private Type.Repetition getRepetition(Descriptors.FieldDescriptor descriptor) {
        if (descriptor.isRequired()) {
            return Type.Repetition.REQUIRED;
        }
        if (descriptor.isRepeated()) {
            return Type.Repetition.REPEATED;
        }
        return Type.Repetition.OPTIONAL;
    }

    private <T> Types.Builder<? extends Types.Builder<?, Types.GroupBuilder<T>>, Types.GroupBuilder<T>> addField(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder) {
        if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return this.addMessageField(descriptor, builder);
        }
        ParquetType parquetType = this.getParquetType(descriptor);
        if (descriptor.isRepeated() && this.parquetSpecsCompliant) {
            return this.addRepeatedPrimitive(parquetType.primitiveType, parquetType.logicalTypeAnnotation, builder);
        }
        return builder.primitive(parquetType.primitiveType, this.getRepetition(descriptor)).as(parquetType.logicalTypeAnnotation);
    }

    private <T> Types.Builder<? extends Types.Builder<?, Types.GroupBuilder<T>>, Types.GroupBuilder<T>> addRepeatedPrimitive(PrimitiveType.PrimitiveTypeName primitiveType, LogicalTypeAnnotation logicalTypeAnnotation, Types.GroupBuilder<T> builder) {
        return (Types.Builder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)builder.group(Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).group(Type.Repetition.REPEATED).primitive(primitiveType, Type.Repetition.REQUIRED).as(logicalTypeAnnotation)).named("element")).named("list");
    }

    private <T> Types.GroupBuilder<Types.GroupBuilder<T>> addRepeatedMessage(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder) {
        Types.GroupBuilder result = ((Types.GroupBuilder)builder.group(Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).group(Type.Repetition.REPEATED).group(Type.Repetition.OPTIONAL);
        this.convertFields(result, descriptor.getMessageType().getFields());
        return (Types.GroupBuilder)((Types.GroupBuilder)result.named("element")).named("list");
    }

    private <T> Types.GroupBuilder<Types.GroupBuilder<T>> addMessageField(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder) {
        if (descriptor.isMapField() && this.parquetSpecsCompliant) {
            return this.addMapField(descriptor, builder);
        }
        if (descriptor.isRepeated() && this.parquetSpecsCompliant) {
            return this.addRepeatedMessage(descriptor, builder);
        }
        Types.GroupBuilder group = builder.group(this.getRepetition(descriptor));
        this.convertFields(group, descriptor.getMessageType().getFields());
        return group;
    }

    private <T> Types.GroupBuilder<Types.GroupBuilder<T>> addMapField(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder) {
        List fields = descriptor.getMessageType().getFields();
        if (fields.size() != 2) {
            throw new UnsupportedOperationException("Expected two fields for the map (key/value), but got: " + fields);
        }
        ParquetType mapKeyParquetType = this.getParquetType((Descriptors.FieldDescriptor)fields.get(0));
        Types.GroupBuilder group = (Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)builder.group(Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).group(Type.Repetition.REPEATED).primitive(mapKeyParquetType.primitiveType, Type.Repetition.REQUIRED).as(mapKeyParquetType.logicalTypeAnnotation)).named("key");
        return (Types.GroupBuilder)((Types.GroupBuilder)this.addField((Descriptors.FieldDescriptor)fields.get(1), group).named("value")).named("key_value");
    }

    private ParquetType getParquetType(Descriptors.FieldDescriptor fieldDescriptor) {
        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
        switch (javaType) {
            case INT: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.INT32);
            }
            case LONG: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.INT64);
            }
            case DOUBLE: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.DOUBLE);
            }
            case BOOLEAN: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BOOLEAN);
            }
            case FLOAT: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.FLOAT);
            }
            case STRING: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
            }
            case ENUM: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.enumType());
            }
            case BYTE_STRING: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BINARY);
            }
        }
        throw new UnsupportedOperationException("Cannot convert Protocol Buffer: unknown type " + javaType);
    }

    private static class ParquetType {
        PrimitiveType.PrimitiveTypeName primitiveType;
        LogicalTypeAnnotation logicalTypeAnnotation;

        private ParquetType(PrimitiveType.PrimitiveTypeName primitiveType, LogicalTypeAnnotation logicalTypeAnnotation) {
            this.primitiveType = primitiveType;
            this.logicalTypeAnnotation = logicalTypeAnnotation;
        }

        public static ParquetType of(PrimitiveType.PrimitiveTypeName primitiveType, LogicalTypeAnnotation logicalTypeAnnotation) {
            return new ParquetType(primitiveType, logicalTypeAnnotation);
        }

        public static ParquetType of(PrimitiveType.PrimitiveTypeName primitiveType) {
            return ParquetType.of(primitiveType, null);
        }
    }
}

