/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.Deque;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.junit.Assert;

public final class ExpectationValidatingRecordConsumer
extends RecordConsumer {
    private final Deque<String> expectations;
    int count = 0;

    public ExpectationValidatingRecordConsumer(Deque<String> expectations) {
        this.expectations = expectations;
    }

    private void validate(String got) {
        Assert.assertEquals((String)("event #" + this.count), (Object)this.expectations.pop(), (Object)got);
        ++this.count;
    }

    public void startMessage() {
        this.validate("startMessage()");
    }

    public void startGroup() {
        this.validate("startGroup()");
    }

    public void startField(String field, int index) {
        this.validate("startField(" + field + ", " + index + ")");
    }

    public void endMessage() {
        this.validate("endMessage()");
    }

    public void endGroup() {
        this.validate("endGroup()");
    }

    public void endField(String field, int index) {
        this.validate("endField(" + field + ", " + index + ")");
    }

    public void addInteger(int value) {
        this.validate("addInt(" + value + ")");
    }

    public void addLong(long value) {
        this.validate("addLong(" + value + ")");
    }

    public void addBoolean(boolean value) {
        this.validate("addBoolean(" + value + ")");
    }

    public void addBinary(Binary value) {
        this.validate("addBinary(" + value.toStringUsingUTF8() + ")");
    }

    public void addFloat(float value) {
        this.validate("addFloat(" + value + ")");
    }

    public void addDouble(double value) {
        this.validate("addDouble(" + value + ")");
    }

    public void flush() {
        this.validate("flush()");
    }
}

