/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.column.columnindex;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.internal.column.columnindex.BoundaryOrder;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBoundaryOrder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestBoundaryOrder.class);
    private static final PrimitiveType TYPE = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("test_int32");
    private static final int FROM = -15;
    private static final int TO = 15;
    private static final ColumnIndexBuilder.ColumnIndexBase<?> ASCENDING;
    private static final ColumnIndexBuilder.ColumnIndexBase<?> DESCENDING;
    private static final int SINGLE_FROM = -1;
    private static final int SINGLE_TO = 1;
    private static final ColumnIndexBuilder.ColumnIndexBase<?> SINGLE;
    private static final Random RANDOM;
    private static final int RAND_FROM = -2000;
    private static final int RAND_TO = 2000;
    private static final int RAND_COUNT = 2000;
    private static final ColumnIndexBuilder.ColumnIndexBase<?> RAND_ASCENDING;
    private static final ColumnIndexBuilder.ColumnIndexBase<?> RAND_DESCENDING;
    private static final ColumnIndexBuilder.ColumnIndexBase<?> ALL_NULL_PAGES;
    private static final SpyValueComparatorBuilder SPY_COMPARATOR_BUILDER;

    private static Statistics<?> stats(int min, int max) {
        Statistics stats = Statistics.createStats((Type)TYPE);
        stats.updateStats(min);
        stats.updateStats(max);
        return stats;
    }

    private static ExecStats validateOperator(String msg, Function<ColumnIndexBuilder.ColumnIndexBase.ValueComparator, PrimitiveIterator.OfInt> validatorOp, Function<ColumnIndexBuilder.ColumnIndexBase.ValueComparator, PrimitiveIterator.OfInt> actualOp, ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
        ExecStats stats = new ExecStats();
        IntList expected = stats.measureLinear(validatorOp, comparator);
        IntList actual = stats.measureBinary(actualOp, comparator);
        Assert.assertEquals((String)msg, (Object)expected, (Object)actual);
        return stats;
    }

    @Test
    public void testEq() {
        int i;
        for (i = -16; i <= 16; ++i) {
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).eq(arg_0), ASCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).eq(arg_0), DESCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with ASCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).eq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with DESCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).eq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
        }
        for (i = -2; i <= 2; ++i) {
            ColumnIndexBuilder.ColumnIndexBase.ValueComparator singleComparator = SINGLE.createValueComparator((Object)i);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).eq(arg_0), singleComparator);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).eq(arg_0), singleComparator);
        }
        ExecStats stats = new ExecStats();
        for (int i2 = -2001; i2 <= 2001; ++i2) {
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).eq(arg_0), RAND_ASCENDING.createValueComparator((Object)i2)));
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).eq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).eq(arg_0), RAND_DESCENDING.createValueComparator((Object)i2)));
        }
        LOGGER.info("Executed eq on random data (page count: {}, values searched: {}):\n{}", new Object[]{2000, 4002, stats});
    }

    @Test
    public void testGt() {
        int i;
        for (i = -16; i <= 16; ++i) {
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gt(arg_0), ASCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gt(arg_0), DESCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with ASCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gt(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with DESCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gt(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
        }
        for (i = -2; i <= 2; ++i) {
            ColumnIndexBuilder.ColumnIndexBase.ValueComparator singleComparator = SINGLE.createValueComparator((Object)i);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gt(arg_0), singleComparator);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gt(arg_0), singleComparator);
        }
        ExecStats stats = new ExecStats();
        for (int i2 = -2001; i2 <= 2001; ++i2) {
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gt(arg_0), RAND_ASCENDING.createValueComparator((Object)i2)));
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gt(arg_0), RAND_DESCENDING.createValueComparator((Object)i2)));
        }
        LOGGER.info("Executed gt on random data (page count: {}, values searched: {}):\n{}", new Object[]{2000, 4002, stats});
    }

    @Test
    public void testGtEq() {
        int i;
        for (i = -16; i <= 16; ++i) {
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gtEq(arg_0), ASCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gtEq(arg_0), DESCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with ASCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gtEq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with DESCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gtEq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
        }
        for (i = -2; i <= 2; ++i) {
            ColumnIndexBuilder.ColumnIndexBase.ValueComparator singleComparator = SINGLE.createValueComparator((Object)i);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gtEq(arg_0), singleComparator);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gtEq(arg_0), singleComparator);
        }
        ExecStats stats = new ExecStats();
        for (int i2 = -2001; i2 <= 2001; ++i2) {
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).gtEq(arg_0), RAND_ASCENDING.createValueComparator((Object)i2)));
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).gtEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).gtEq(arg_0), RAND_DESCENDING.createValueComparator((Object)i2)));
        }
        LOGGER.info("Executed gtEq on random data (page count: {}, values searched: {}):\n{}", new Object[]{2000, 4002, stats});
    }

    @Test
    public void testLt() {
        int i;
        for (i = -16; i <= 16; ++i) {
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).lt(arg_0), ASCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).lt(arg_0), DESCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with ASCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).lt(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with DESCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).lt(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
        }
        for (i = -2; i <= 2; ++i) {
            ColumnIndexBuilder.ColumnIndexBase.ValueComparator singleComparator = SINGLE.createValueComparator((Object)i);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).lt(arg_0), singleComparator);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).lt(arg_0), singleComparator);
        }
        ExecStats stats = new ExecStats();
        for (int i2 = -2001; i2 <= 2001; ++i2) {
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).lt(arg_0), RAND_ASCENDING.createValueComparator((Object)i2)));
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).lt(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).lt(arg_0), RAND_DESCENDING.createValueComparator((Object)i2)));
        }
        LOGGER.info("Executed lt on random data (page count: {}, values searched: {}):\n{}", new Object[]{2000, 4002, stats});
    }

    @Test
    public void testLtEq() {
        int i;
        for (i = -16; i <= 16; ++i) {
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).ltEq(arg_0), ASCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).ltEq(arg_0), DESCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with ASCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).ltEq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with DESCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).ltEq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
        }
        for (i = -2; i <= 2; ++i) {
            ColumnIndexBuilder.ColumnIndexBase.ValueComparator singleComparator = SINGLE.createValueComparator((Object)i);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).ltEq(arg_0), singleComparator);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).ltEq(arg_0), singleComparator);
        }
        ExecStats stats = new ExecStats();
        for (int i2 = -2001; i2 <= 2001; ++i2) {
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).ltEq(arg_0), RAND_ASCENDING.createValueComparator((Object)i2)));
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).ltEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).ltEq(arg_0), RAND_DESCENDING.createValueComparator((Object)i2)));
        }
        LOGGER.info("Executed ltEq on random data (page count: {}, values searched: {}):\n{}", new Object[]{2000, 4002, stats});
    }

    @Test
    public void testNotEq() {
        int i;
        for (i = -16; i <= 16; ++i) {
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).notEq(arg_0), ASCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).notEq(arg_0), DESCENDING.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with ASCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).notEq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
            TestBoundaryOrder.validateOperator("Mismatching page indexes for all null pages and value " + i + " with DESCENDING order in ", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).notEq(arg_0), ALL_NULL_PAGES.createValueComparator((Object)i));
        }
        for (i = -16; i <= 16; ++i) {
            ColumnIndexBuilder.ColumnIndexBase.ValueComparator singleComparator = SINGLE.createValueComparator((Object)i);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).notEq(arg_0), singleComparator);
            TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).notEq(arg_0), singleComparator);
        }
        ExecStats stats = new ExecStats();
        for (int i2 = -2001; i2 <= 2001; ++i2) {
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with ASCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.ASCENDING).notEq(arg_0), RAND_ASCENDING.createValueComparator((Object)i2)));
            stats.add(TestBoundaryOrder.validateOperator("Mismatching page indexes for value " + i2 + " with DESCENDING order", arg_0 -> ((BoundaryOrder)BoundaryOrder.UNORDERED).notEq(arg_0), arg_0 -> ((BoundaryOrder)BoundaryOrder.DESCENDING).notEq(arg_0), RAND_DESCENDING.createValueComparator((Object)i2)));
        }
        LOGGER.info("Executed notEq on random data (page count: {}, values searched: {}):\n{}", new Object[]{2000, 4002, stats});
    }

    static {
        RANDOM = new Random(42L);
        SPY_COMPARATOR_BUILDER = new SpyValueComparatorBuilder();
        ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)TYPE, (int)Integer.MAX_VALUE);
        builder.add(TestBoundaryOrder.stats(-15, -12));
        builder.add(TestBoundaryOrder.stats(-10, -8));
        builder.add(TestBoundaryOrder.stats(-8, -4));
        builder.add(TestBoundaryOrder.stats(-6, -4));
        builder.add(TestBoundaryOrder.stats(-6, -3));
        builder.add(TestBoundaryOrder.stats(-6, -3));
        builder.add(TestBoundaryOrder.stats(-6, -3));
        builder.add(TestBoundaryOrder.stats(0, 3));
        builder.add(TestBoundaryOrder.stats(3, 5));
        builder.add(TestBoundaryOrder.stats(3, 5));
        builder.add(TestBoundaryOrder.stats(5, 8));
        builder.add(TestBoundaryOrder.stats(10, 15));
        ASCENDING = (ColumnIndexBuilder.ColumnIndexBase)builder.build();
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)TYPE, (int)Integer.MAX_VALUE);
        builder.add(TestBoundaryOrder.stats(10, 15));
        builder.add(TestBoundaryOrder.stats(5, 8));
        builder.add(TestBoundaryOrder.stats(3, 5));
        builder.add(TestBoundaryOrder.stats(3, 5));
        builder.add(TestBoundaryOrder.stats(0, 3));
        builder.add(TestBoundaryOrder.stats(-6, -3));
        builder.add(TestBoundaryOrder.stats(-6, -3));
        builder.add(TestBoundaryOrder.stats(-6, -3));
        builder.add(TestBoundaryOrder.stats(-6, -4));
        builder.add(TestBoundaryOrder.stats(-8, -4));
        builder.add(TestBoundaryOrder.stats(-10, -8));
        builder.add(TestBoundaryOrder.stats(-15, -12));
        DESCENDING = (ColumnIndexBuilder.ColumnIndexBase)builder.build();
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)TYPE, (int)Integer.MAX_VALUE);
        builder.add(TestBoundaryOrder.stats(-1, 1));
        SINGLE = (ColumnIndexBuilder.ColumnIndexBase)builder.build();
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)TYPE, (int)Integer.MAX_VALUE);
        Iterator<Integer> it = IntStream.generate(() -> RANDOM.nextInt(4001) + -2000).limit(4000L).sorted().iterator();
        while (it.hasNext()) {
            builder.add(TestBoundaryOrder.stats(it.nextInt(), it.nextInt()));
        }
        RAND_ASCENDING = (ColumnIndexBuilder.ColumnIndexBase)builder.build();
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)TYPE, (int)Integer.MAX_VALUE);
        it = IntStream.generate(() -> RANDOM.nextInt(4001) + -2000).limit(4000L).mapToObj(Integer::valueOf).sorted(Collections.reverseOrder()).iterator();
        while (it.hasNext()) {
            builder.add(TestBoundaryOrder.stats(it.next(), it.next()));
        }
        RAND_DESCENDING = (ColumnIndexBuilder.ColumnIndexBase)builder.build();
        builder = ColumnIndexBuilder.getBuilder((PrimitiveType)TYPE, (int)Integer.MAX_VALUE);
        for (int i = 0; i < 10; ++i) {
            builder.add(Statistics.createStats((Type)TYPE));
        }
        ALL_NULL_PAGES = (ColumnIndexBuilder.ColumnIndexBase)builder.build();
    }

    private static class ExecStats {
        private long linearTime;
        private long binaryTime;
        private int linearCompareCount;
        private int binaryCompareCount;
        private int execCount;

        private ExecStats() {
        }

        IntList measureLinear(Function<ColumnIndexBuilder.ColumnIndexBase.ValueComparator, PrimitiveIterator.OfInt> op, ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            IntArrayList list = new IntArrayList(comparator.arrayLength());
            SpyValueComparatorBuilder.SpyValueComparator spyComparator = SPY_COMPARATOR_BUILDER.build(comparator);
            long start = System.nanoTime();
            op.apply(spyComparator).forEachRemaining(arg_0 -> ExecStats.lambda$measureLinear$0((IntList)list, arg_0));
            this.linearTime = System.nanoTime() - start;
            this.linearCompareCount += spyComparator.getCompareCount();
            return list;
        }

        IntList measureBinary(Function<ColumnIndexBuilder.ColumnIndexBase.ValueComparator, PrimitiveIterator.OfInt> op, ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            IntArrayList list = new IntArrayList(comparator.arrayLength());
            SpyValueComparatorBuilder.SpyValueComparator spyComparator = SPY_COMPARATOR_BUILDER.build(comparator);
            long start = System.nanoTime();
            op.apply(spyComparator).forEachRemaining(arg_0 -> ExecStats.lambda$measureBinary$1((IntList)list, arg_0));
            this.binaryTime = System.nanoTime() - start;
            this.binaryCompareCount += spyComparator.getCompareCount();
            return list;
        }

        void add(ExecStats stats) {
            this.linearTime += stats.linearTime;
            this.linearCompareCount += stats.linearCompareCount;
            this.binaryTime += stats.binaryTime;
            this.binaryCompareCount += stats.binaryCompareCount;
            ++this.execCount;
        }

        public String toString() {
            double linearMs = (double)this.linearTime / 1000000.0;
            double binaryMs = (double)this.binaryTime / 1000000.0;
            return String.format("Linear search: %.2fms (avg: %.6fms); number of compares: %d (avg: %d) [100.00%%]%nBinary search: %.2fms (avg: %.6fms); number of compares: %d (avg: %d) [%.2f%%]", linearMs, linearMs / (double)this.execCount, this.linearCompareCount, this.linearCompareCount / this.execCount, binaryMs, binaryMs / (double)this.execCount, this.binaryCompareCount, this.binaryCompareCount / this.execCount, 100.0 * (double)this.binaryCompareCount / (double)this.linearCompareCount);
        }

        private static /* synthetic */ void lambda$measureBinary$1(IntList list, int value) {
            list.add(value);
        }

        private static /* synthetic */ void lambda$measureLinear$0(IntList list, int value) {
            list.add(value);
        }
    }

    private static class SpyValueComparatorBuilder
    extends ColumnIndexBuilder.ColumnIndexBase<Integer> {
        private SpyValueComparatorBuilder() {
            super(TYPE);
        }

        SpyValueComparator build(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
            return new SpyValueComparator(comparator);
        }

        ByteBuffer getMinValueAsBytes(int arrayIndex) {
            throw new Error("Shall never be invoked");
        }

        ByteBuffer getMaxValueAsBytes(int arrayIndex) {
            throw new Error("Shall never be invoked");
        }

        String getMinValueAsString(int arrayIndex) {
            throw new Error("Shall never be invoked");
        }

        String getMaxValueAsString(int arrayIndex) {
            throw new Error("Shall never be invoked");
        }

        <T extends Comparable<T>> org.apache.parquet.filter2.predicate.Statistics<T> createStats(int arrayIndex) {
            throw new Error("Shall never be invoked");
        }

        ColumnIndexBuilder.ColumnIndexBase.ValueComparator createValueComparator(Object value) {
            throw new Error("Shall never be invoked");
        }

        class SpyValueComparator
        extends ColumnIndexBuilder.ColumnIndexBase.ValueComparator {
            private final ColumnIndexBuilder.ColumnIndexBase.ValueComparator delegate;
            private int compareCount;

            SpyValueComparator(ColumnIndexBuilder.ColumnIndexBase.ValueComparator delegate) {
                super((ColumnIndexBuilder.ColumnIndexBase)SpyValueComparatorBuilder.this);
                this.delegate = delegate;
            }

            int getCompareCount() {
                return this.compareCount;
            }

            int arrayLength() {
                return this.delegate.arrayLength();
            }

            int translate(int arrayIndex) {
                return this.delegate.translate(arrayIndex);
            }

            int compareValueToMin(int arrayIndex) {
                ++this.compareCount;
                return this.delegate.compareValueToMin(arrayIndex);
            }

            int compareValueToMax(int arrayIndex) {
                ++this.compareCount;
                return this.delegate.compareValueToMax(arrayIndex);
            }
        }
    }
}

