/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.dictionary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.dictionary.DictionaryValuesReader;
import org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import org.apache.parquet.column.values.fallback.FallbackValuesWriter;
import org.apache.parquet.column.values.plain.BinaryPlainValuesReader;
import org.apache.parquet.column.values.plain.PlainValuesReader;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class TestDictionary {
    private <I extends DictionaryValuesWriter> FallbackValuesWriter<I, PlainValuesWriter> plainFallBack(I dvw, int initialSize) {
        return FallbackValuesWriter.of(dvw, (ValuesWriter)new PlainValuesWriter(initialSize, initialSize * 5, (ByteBufferAllocator)new DirectByteBufferAllocator()));
    }

    private FallbackValuesWriter<DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter, PlainValuesWriter> newPlainBinaryDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
        return this.plainFallBack(new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(maxDictionaryByteSize, Encoding.PLAIN_DICTIONARY, Encoding.PLAIN_DICTIONARY, (ByteBufferAllocator)new DirectByteBufferAllocator()), initialSize);
    }

    private FallbackValuesWriter<DictionaryValuesWriter.PlainLongDictionaryValuesWriter, PlainValuesWriter> newPlainLongDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
        return this.plainFallBack(new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(maxDictionaryByteSize, Encoding.PLAIN_DICTIONARY, Encoding.PLAIN_DICTIONARY, (ByteBufferAllocator)new DirectByteBufferAllocator()), initialSize);
    }

    private FallbackValuesWriter<DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter, PlainValuesWriter> newPlainIntegerDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
        return this.plainFallBack(new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(maxDictionaryByteSize, Encoding.PLAIN_DICTIONARY, Encoding.PLAIN_DICTIONARY, (ByteBufferAllocator)new DirectByteBufferAllocator()), initialSize);
    }

    private FallbackValuesWriter<DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter, PlainValuesWriter> newPlainDoubleDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
        return this.plainFallBack(new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(maxDictionaryByteSize, Encoding.PLAIN_DICTIONARY, Encoding.PLAIN_DICTIONARY, (ByteBufferAllocator)new DirectByteBufferAllocator()), initialSize);
    }

    private FallbackValuesWriter<DictionaryValuesWriter.PlainFloatDictionaryValuesWriter, PlainValuesWriter> newPlainFloatDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
        return this.plainFallBack(new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(maxDictionaryByteSize, Encoding.PLAIN_DICTIONARY, Encoding.PLAIN_DICTIONARY, (ByteBufferAllocator)new DirectByteBufferAllocator()), initialSize);
    }

    @Test
    public void testBinaryDictionary() throws IOException {
        int COUNT = 100;
        FallbackValuesWriter<DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainBinaryDictionaryValuesWriter(200, 10000);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "b");
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeDistinct(COUNT, (ValuesWriter)cw, "c");
        BytesInput bytes3 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.BINARY);
        this.checkRepeated(COUNT, bytes1, (ValuesReader)cr, "a");
        this.checkRepeated(COUNT, bytes2, (ValuesReader)cr, "b");
        BinaryPlainValuesReader cr2 = new BinaryPlainValuesReader();
        this.checkDistinct(COUNT, bytes3, (ValuesReader)cr2, "c");
    }

    @Test
    public void testSkipInBinaryDictionary() throws Exception {
        int i;
        int skipCount;
        FallbackValuesWriter<DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainBinaryDictionaryValuesWriter(1000, 10000);
        this.writeRepeated(100, (ValuesWriter)cw, "a");
        this.writeDistinct(100, (ValuesWriter)cw, "b");
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        ByteBufferInputStream stream = cw.getBytes().toInputStream();
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.BINARY);
        cr.initFromPage(200, stream);
        for (int i2 = 0; i2 < 100; i2 += 2) {
            Assert.assertEquals((Object)Binary.fromString((String)("a" + i2 % 10)), (Object)cr.readBytes());
            cr.skip();
        }
        for (int i3 = 0; i3 < 100; i3 += skipCount + 1) {
            skipCount = (100 - i3) / 2;
            Assert.assertEquals((Object)Binary.fromString((String)("b" + i3)), (Object)cr.readBytes());
            cr.skip(skipCount);
        }
        this.writeDistinct(1000, (ValuesWriter)cw, "c");
        Assert.assertEquals((Object)Encoding.PLAIN, (Object)cw.getEncoding());
        BinaryPlainValuesReader plainReader = new BinaryPlainValuesReader();
        plainReader.initFromPage(1200, cw.getBytes().toInputStream());
        plainReader.skip(200);
        for (i = 0; i < 100; i += 2) {
            Assert.assertEquals((Object)("c" + i), (Object)plainReader.readBytes().toStringUsingUTF8());
            plainReader.skip();
        }
        for (i = 100; i < 1000; i += skipCount + 1) {
            skipCount = (1000 - i) / 2;
            Assert.assertEquals((Object)Binary.fromString((String)("c" + i)), (Object)plainReader.readBytes());
            plainReader.skip(skipCount);
        }
    }

    @Test
    public void testBinaryDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        FallbackValuesWriter<DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainBinaryDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        int fallBackThreshold = maxDictionaryByteSize;
        int dataSize = 0;
        for (long i = 0L; i < 100L; ++i) {
            Binary binary = Binary.fromString((String)("str" + i));
            cw.writeBytes(binary);
            if ((dataSize += binary.length() + 4) < fallBackThreshold) {
                Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
                continue;
            }
            Assert.assertEquals((Object)Encoding.PLAIN, (Object)cw.getEncoding());
        }
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (long i = 0L; i < 100L; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)("str" + i)), (Object)reader.readBytes());
        }
        cw.reset();
        Assert.assertEquals((long)0L, (long)cw.getBufferedSize());
    }

    @Test
    public void testBinaryDictionaryChangedValues() throws IOException {
        int COUNT = 100;
        FallbackValuesWriter<DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainBinaryDictionaryValuesWriter(200, 10000);
        this.writeRepeatedWithReuse(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeRepeatedWithReuse(COUNT, (ValuesWriter)cw, "b");
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeDistinct(COUNT, (ValuesWriter)cw, "c");
        BytesInput bytes3 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.BINARY);
        this.checkRepeated(COUNT, bytes1, (ValuesReader)cr, "a");
        this.checkRepeated(COUNT, bytes2, (ValuesReader)cr, "b");
        BinaryPlainValuesReader cr2 = new BinaryPlainValuesReader();
        this.checkDistinct(COUNT, bytes3, (ValuesReader)cr2, "c");
    }

    @Test
    public void testFirstPageFallBack() throws IOException {
        int COUNT = 1000;
        FallbackValuesWriter<DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainBinaryDictionaryValuesWriter(10000, 10000);
        this.writeDistinct(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "b");
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        BinaryPlainValuesReader cr = new BinaryPlainValuesReader();
        this.checkDistinct(COUNT, bytes1, (ValuesReader)cr, "a");
        this.checkRepeated(COUNT, bytes2, (ValuesReader)cr, "b");
    }

    @Test
    public void testSecondPageFallBack() throws IOException {
        int COUNT = 1000;
        FallbackValuesWriter<DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainBinaryDictionaryValuesWriter(1000, 10000);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeDistinct(COUNT, (ValuesWriter)cw, "b");
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes3 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.BINARY);
        this.checkRepeated(COUNT, bytes1, (ValuesReader)cr, "a");
        cr = new BinaryPlainValuesReader();
        this.checkDistinct(COUNT, bytes2, (ValuesReader)cr, "b");
        this.checkRepeated(COUNT, bytes3, (ValuesReader)cr, "a");
    }

    @Test
    public void testLongDictionary() throws IOException {
        long back;
        long i;
        int COUNT = 1000;
        int COUNT2 = 2000;
        FallbackValuesWriter<DictionaryValuesWriter.PlainLongDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainLongDictionaryValuesWriter(10000, 10000);
        for (long i2 = 0L; i2 < (long)COUNT; ++i2) {
            cw.writeLong(i2 % 50L);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainLongDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        for (long i3 = (long)COUNT2; i3 > 0L; --i3) {
            cw.writeLong(i3 % 50L);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainLongDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.INT64);
        cr.initFromPage(COUNT, bytes1.toInputStream());
        for (i = 0L; i < (long)COUNT; ++i) {
            back = cr.readLong();
            Assert.assertEquals((long)(i % 50L), (long)back);
        }
        cr.initFromPage(COUNT2, bytes2.toInputStream());
        for (i = (long)COUNT2; i > 0L; --i) {
            back = cr.readLong();
            Assert.assertEquals((long)(i % 50L), (long)back);
        }
    }

    private void roundTripLong(FallbackValuesWriter<DictionaryValuesWriter.PlainLongDictionaryValuesWriter, PlainValuesWriter> cw, ValuesReader reader, int maxDictionaryByteSize) throws IOException {
        int skipCount;
        long i;
        int fallBackThreshold = maxDictionaryByteSize / 8;
        for (i = 0L; i < 100L; ++i) {
            cw.writeLong(i);
            if (i < (long)fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (i = 0L; i < 100L; ++i) {
            Assert.assertEquals((long)i, (long)reader.readLong());
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (int i2 = 0; i2 < 100; i2 += 2) {
            Assert.assertEquals((long)i2, (long)reader.readLong());
            reader.skip();
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (int i3 = 0; i3 < 100; i3 += skipCount + 1) {
            skipCount = (100 - i3) / 2;
            Assert.assertEquals((long)i3, (long)reader.readLong());
            reader.skip(skipCount);
        }
    }

    @Test
    public void testLongDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        FallbackValuesWriter<DictionaryValuesWriter.PlainLongDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainLongDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        PlainValuesReader.LongPlainValuesReader reader = new PlainValuesReader.LongPlainValuesReader();
        this.roundTripLong(cw, (ValuesReader)reader, maxDictionaryByteSize);
        cw.reset();
        Assert.assertEquals((long)0L, (long)cw.getBufferedSize());
        cw.resetDictionary();
        this.roundTripLong(cw, (ValuesReader)reader, maxDictionaryByteSize);
    }

    @Test
    public void testDoubleDictionary() throws IOException {
        double back;
        double i;
        int COUNT = 1000;
        int COUNT2 = 2000;
        FallbackValuesWriter<DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainDoubleDictionaryValuesWriter(10000, 10000);
        for (double i2 = 0.0; i2 < (double)COUNT; i2 += 1.0) {
            cw.writeDouble(i2 % 50.0);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        for (double i3 = (double)COUNT2; i3 > 0.0; i3 -= 1.0) {
            cw.writeDouble(i3 % 50.0);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.DOUBLE);
        cr.initFromPage(COUNT, bytes1.toInputStream());
        for (i = 0.0; i < (double)COUNT; i += 1.0) {
            back = cr.readDouble();
            Assert.assertEquals((double)(i % 50.0), (double)back, (double)0.0);
        }
        cr.initFromPage(COUNT2, bytes2.toInputStream());
        for (i = (double)COUNT2; i > 0.0; i -= 1.0) {
            back = cr.readDouble();
            Assert.assertEquals((double)(i % 50.0), (double)back, (double)0.0);
        }
    }

    private void roundTripDouble(FallbackValuesWriter<DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter, PlainValuesWriter> cw, ValuesReader reader, int maxDictionaryByteSize) throws IOException {
        int skipCount;
        double i;
        int fallBackThreshold = maxDictionaryByteSize / 8;
        for (i = 0.0; i < 100.0; i += 1.0) {
            cw.writeDouble(i);
            if (i < (double)fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (i = 0.0; i < 100.0; i += 1.0) {
            Assert.assertEquals((double)i, (double)reader.readDouble(), (double)1.0E-5);
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (int i2 = 0; i2 < 100; i2 += 2) {
            Assert.assertEquals((double)i2, (double)reader.readDouble(), (double)0.0);
            reader.skip();
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (int i3 = 0; i3 < 100; i3 += skipCount + 1) {
            skipCount = (100 - i3) / 2;
            Assert.assertEquals((double)i3, (double)reader.readDouble(), (double)0.0);
            reader.skip(skipCount);
        }
    }

    @Test
    public void testDoubleDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        FallbackValuesWriter<DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainDoubleDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        PlainValuesReader.DoublePlainValuesReader reader = new PlainValuesReader.DoublePlainValuesReader();
        this.roundTripDouble(cw, (ValuesReader)reader, maxDictionaryByteSize);
        cw.reset();
        Assert.assertEquals((long)0L, (long)cw.getBufferedSize());
        cw.resetDictionary();
        this.roundTripDouble(cw, (ValuesReader)reader, maxDictionaryByteSize);
    }

    @Test
    public void testIntDictionary() throws IOException {
        int back;
        int i;
        int COUNT = 2000;
        int COUNT2 = 4000;
        FallbackValuesWriter<DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainIntegerDictionaryValuesWriter(10000, 10000);
        for (int i2 = 0; i2 < COUNT; ++i2) {
            cw.writeInteger(i2 % 50);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        for (int i3 = COUNT2; i3 > 0; --i3) {
            cw.writeInteger(i3 % 50);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.INT32);
        cr.initFromPage(COUNT, bytes1.toInputStream());
        for (i = 0; i < COUNT; ++i) {
            back = cr.readInteger();
            Assert.assertEquals((long)(i % 50), (long)back);
        }
        cr.initFromPage(COUNT2, bytes2.toInputStream());
        for (i = COUNT2; i > 0; --i) {
            back = cr.readInteger();
            Assert.assertEquals((long)(i % 50), (long)back);
        }
    }

    private void roundTripInt(FallbackValuesWriter<DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter, PlainValuesWriter> cw, ValuesReader reader, int maxDictionaryByteSize) throws IOException {
        int skipCount;
        int i;
        int fallBackThreshold = maxDictionaryByteSize / 4;
        for (i = 0; i < 100; ++i) {
            cw.writeInteger(i);
            if (i < fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)i, (long)reader.readInteger());
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (i = 0; i < 100; i += 2) {
            Assert.assertEquals((long)i, (long)reader.readInteger());
            reader.skip();
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (int i2 = 0; i2 < 100; i2 += skipCount + 1) {
            skipCount = (100 - i2) / 2;
            Assert.assertEquals((long)i2, (long)reader.readInteger());
            reader.skip(skipCount);
        }
    }

    @Test
    public void testIntDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        FallbackValuesWriter<DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainIntegerDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        PlainValuesReader.IntegerPlainValuesReader reader = new PlainValuesReader.IntegerPlainValuesReader();
        this.roundTripInt(cw, (ValuesReader)reader, maxDictionaryByteSize);
        cw.reset();
        Assert.assertEquals((long)0L, (long)cw.getBufferedSize());
        cw.resetDictionary();
        this.roundTripInt(cw, (ValuesReader)reader, maxDictionaryByteSize);
    }

    @Test
    public void testFloatDictionary() throws IOException {
        float back;
        float i;
        int COUNT = 2000;
        int COUNT2 = 4000;
        FallbackValuesWriter<DictionaryValuesWriter.PlainFloatDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainFloatDictionaryValuesWriter(10000, 10000);
        for (float i2 = 0.0f; i2 < (float)COUNT; i2 += 1.0f) {
            cw.writeFloat(i2 % 50.0f);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainFloatDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        for (float i3 = (float)COUNT2; i3 > 0.0f; i3 -= 1.0f) {
            cw.writeFloat(i3 % 50.0f);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)((DictionaryValuesWriter.PlainFloatDictionaryValuesWriter)cw.initialWriter).getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.FLOAT);
        cr.initFromPage(COUNT, bytes1.toInputStream());
        for (i = 0.0f; i < (float)COUNT; i += 1.0f) {
            back = cr.readFloat();
            Assert.assertEquals((float)(i % 50.0f), (float)back, (float)0.0f);
        }
        cr.initFromPage(COUNT2, bytes2.toInputStream());
        for (i = (float)COUNT2; i > 0.0f; i -= 1.0f) {
            back = cr.readFloat();
            Assert.assertEquals((float)(i % 50.0f), (float)back, (float)0.0f);
        }
    }

    private void roundTripFloat(FallbackValuesWriter<DictionaryValuesWriter.PlainFloatDictionaryValuesWriter, PlainValuesWriter> cw, ValuesReader reader, int maxDictionaryByteSize) throws IOException {
        int skipCount;
        float i;
        int fallBackThreshold = maxDictionaryByteSize / 4;
        for (i = 0.0f; i < 100.0f; i += 1.0f) {
            cw.writeFloat(i);
            if (i < (float)fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (i = 0.0f; i < 100.0f; i += 1.0f) {
            Assert.assertEquals((double)i, (double)reader.readFloat(), (double)1.0E-5);
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (int i2 = 0; i2 < 100; i2 += 2) {
            Assert.assertEquals((float)i2, (float)reader.readFloat(), (float)0.0f);
            reader.skip();
        }
        reader.initFromPage(100, cw.getBytes().toInputStream());
        for (int i3 = 0; i3 < 100; i3 += skipCount + 1) {
            skipCount = (100 - i3) / 2;
            Assert.assertEquals((float)i3, (float)reader.readFloat(), (float)0.0f);
            reader.skip(skipCount);
        }
    }

    @Test
    public void testFloatDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        FallbackValuesWriter<DictionaryValuesWriter.PlainFloatDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainFloatDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        PlainValuesReader.FloatPlainValuesReader reader = new PlainValuesReader.FloatPlainValuesReader();
        this.roundTripFloat(cw, (ValuesReader)reader, maxDictionaryByteSize);
        cw.reset();
        Assert.assertEquals((long)0L, (long)cw.getBufferedSize());
        cw.resetDictionary();
        this.roundTripFloat(cw, (ValuesReader)reader, maxDictionaryByteSize);
    }

    @Test
    public void testZeroValues() throws IOException {
        FallbackValuesWriter<DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter, PlainValuesWriter> cw = this.newPlainIntegerDictionaryValuesWriter(100, 100);
        cw.writeInteger(34);
        cw.writeInteger(34);
        this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        DictionaryValuesReader reader = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.INT32);
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{0, 1, 2, 3});
        ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{bytes});
        stream.skipFully((long)stream.available());
        reader.initFromPage(100, stream);
        reader = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.INT32);
        int offset = bytes.remaining();
        reader.initFromPage(100, bytes, offset);
    }

    private DictionaryValuesReader initDicReader(ValuesWriter cw, PrimitiveType.PrimitiveTypeName type) throws IOException {
        DictionaryPage dictionaryPage = cw.toDictPageAndClose().copy();
        ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"foo"}, type, 0, 0);
        Dictionary dictionary = Encoding.PLAIN.initDictionary(descriptor, dictionaryPage);
        DictionaryValuesReader cr = new DictionaryValuesReader(dictionary);
        return cr;
    }

    private void checkDistinct(int COUNT, BytesInput bytes, ValuesReader cr, String prefix) throws IOException {
        cr.initFromPage(COUNT, bytes.toInputStream());
        for (int i = 0; i < COUNT; ++i) {
            Assert.assertEquals((Object)(prefix + i), (Object)cr.readBytes().toStringUsingUTF8());
        }
    }

    private void checkRepeated(int COUNT, BytesInput bytes, ValuesReader cr, String prefix) throws IOException {
        cr.initFromPage(COUNT, bytes.toInputStream());
        for (int i = 0; i < COUNT; ++i) {
            Assert.assertEquals((Object)(prefix + i % 10), (Object)cr.readBytes().toStringUsingUTF8());
        }
    }

    private void writeDistinct(int COUNT, ValuesWriter cw, String prefix) {
        for (int i = 0; i < COUNT; ++i) {
            cw.writeBytes(Binary.fromString((String)(prefix + i)));
        }
    }

    private void writeRepeated(int COUNT, ValuesWriter cw, String prefix) {
        for (int i = 0; i < COUNT; ++i) {
            cw.writeBytes(Binary.fromString((String)(prefix + i % 10)));
        }
    }

    private void writeRepeatedWithReuse(int COUNT, ValuesWriter cw, String prefix) {
        Binary reused = Binary.fromReusedByteArray((byte[])(prefix + "0").getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < COUNT; ++i) {
            Binary content = Binary.fromString((String)(prefix + i % 10));
            System.arraycopy(content.getBytesUnsafe(), 0, reused.getBytesUnsafe(), 0, reused.length());
            cw.writeBytes(reused);
        }
    }

    private BytesInput getBytesAndCheckEncoding(ValuesWriter cw, Encoding encoding) throws IOException {
        BytesInput bytes = BytesInput.copy((BytesInput)cw.getBytes());
        Assert.assertEquals((Object)encoding, (Object)cw.getEncoding());
        cw.reset();
        return bytes;
    }
}

