/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.deltastrings;

import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.Utils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestDeltaByteArray {
    static String[] values = new String[]{"parquet-mr", "parquet", "parquet-format"};
    static String[] randvalues = Utils.getRandomStringSamples(10000, 32);

    @Test
    public void testSerialization() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        this.assertReadWrite(writer, reader, values);
    }

    @Test
    public void testRandomStrings() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        this.assertReadWrite(writer, reader, randvalues);
    }

    @Test
    public void testRandomStringsWithSkip() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        this.assertReadWriteWithSkip(writer, reader, randvalues);
    }

    @Test
    public void testRandomStringsWithSkipN() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        this.assertReadWriteWithSkipN(writer, reader, randvalues);
    }

    @Test
    public void testLengths() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaBinaryPackingValuesReader reader = new DeltaBinaryPackingValuesReader();
        Utils.writeData((ValuesWriter)writer, values);
        ByteBufferInputStream data = writer.getBytes().toInputStream();
        int[] bin = Utils.readInts((ValuesReader)reader, data, values.length);
        Assert.assertEquals((long)0L, (long)bin[0]);
        Assert.assertEquals((long)7L, (long)bin[1]);
        Assert.assertEquals((long)7L, (long)bin[2]);
        reader = new DeltaBinaryPackingValuesReader();
        bin = Utils.readInts((ValuesReader)reader, data, values.length);
        Assert.assertEquals((long)10L, (long)bin[0]);
        Assert.assertEquals((long)0L, (long)bin[1]);
        Assert.assertEquals((long)7L, (long)bin[2]);
    }

    private void assertReadWrite(DeltaByteArrayWriter writer, DeltaByteArrayReader reader, String[] vals) throws Exception {
        Utils.writeData((ValuesWriter)writer, vals);
        Binary[] bin = Utils.readData((ValuesReader)reader, writer.getBytes().toInputStream(), vals.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)vals[i]), (Object)bin[i]);
        }
    }

    private void assertReadWriteWithSkip(DeltaByteArrayWriter writer, DeltaByteArrayReader reader, String[] vals) throws Exception {
        Utils.writeData((ValuesWriter)writer, vals);
        reader.initFromPage(vals.length, writer.getBytes().toInputStream());
        for (int i = 0; i < vals.length; i += 2) {
            Assert.assertEquals((Object)Binary.fromString((String)vals[i]), (Object)reader.readBytes());
            reader.skip();
        }
    }

    private void assertReadWriteWithSkipN(DeltaByteArrayWriter writer, DeltaByteArrayReader reader, String[] vals) throws Exception {
        int skipCount;
        Utils.writeData((ValuesWriter)writer, vals);
        reader.initFromPage(vals.length, writer.getBytes().toInputStream());
        for (int i = 0; i < vals.length; i += skipCount + 1) {
            skipCount = (vals.length - i) / 2;
            Assert.assertEquals((Object)Binary.fromString((String)vals[i]), (Object)reader.readBytes());
            reader.skip(skipCount);
        }
    }

    @Test
    public void testWriterReset() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        this.assertReadWrite(writer, new DeltaByteArrayReader(), values);
        writer.reset();
        this.assertReadWrite(writer, new DeltaByteArrayReader(), values);
    }
}

