/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.logging;

import java.util.Locale;
import org.fusesource.jansi.Ansi;

enum Style {
    DEBUG("bold,cyan"),
    INFO("bold,blue"),
    WARNING("bold,yellow"),
    ERROR("bold,red"),
    SUCCESS("bold,green"),
    FAILURE("bold,red"),
    STRONG("bold"),
    MOJO("green"),
    PROJECT("cyan");

    private final boolean bold;
    private final boolean bright;
    private final Ansi.Color color;
    private final boolean bgBright;
    private final Ansi.Color bgColor;

    private Style(String defaultValue) {
        boolean currentBold = false;
        boolean currentBright = false;
        Ansi.Color currentColor = null;
        boolean currentBgBright = false;
        Ansi.Color currentBgColor = null;
        String value = System.getProperty("style." + this.name().toLowerCase(Locale.ENGLISH), defaultValue).toLowerCase(Locale.ENGLISH);
        for (String token : value.split(",")) {
            if ("bold".equals(token)) {
                currentBold = true;
                continue;
            }
            if (token.startsWith("bg")) {
                if ((token = token.substring(2)).startsWith("bright")) {
                    currentBgBright = true;
                    token = token.substring(6);
                }
                currentBgColor = Style.toColor(token);
                continue;
            }
            if (token.startsWith("bright")) {
                currentBright = true;
                token = token.substring(6);
            }
            currentColor = Style.toColor(token);
        }
        this.bold = currentBold;
        this.bright = currentBright;
        this.color = currentColor;
        this.bgBright = currentBgBright;
        this.bgColor = currentBgColor;
    }

    private static Ansi.Color toColor(String token) {
        for (Ansi.Color color : Ansi.Color.values()) {
            if (!color.toString().equalsIgnoreCase(token)) continue;
            return color;
        }
        return null;
    }

    Ansi apply(Ansi ansi) {
        if (this.bold) {
            ansi.bold();
        }
        if (this.color != null) {
            if (this.bright) {
                ansi.fgBright(this.color);
            } else {
                ansi.fg(this.color);
            }
        }
        if (this.bgColor != null) {
            if (this.bgBright) {
                ansi.bgBright(this.bgColor);
            } else {
                ansi.bg(this.bgColor);
            }
        }
        return ansi;
    }

    public String toString() {
        if (!this.bold && this.color == null && this.bgColor == null) {
            return this.name();
        }
        StringBuilder sb = new StringBuilder(this.name() + '=');
        if (this.bold) {
            sb.append("bold");
        }
        if (this.color != null) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (this.bright) {
                sb.append("bright");
            }
            sb.append(this.color.name());
        }
        if (this.bgColor != null) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("bg");
            if (this.bgBright) {
                sb.append("bright");
            }
            sb.append(this.bgColor.name());
        }
        return sb.toString();
    }
}

