/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.types.DataType;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RawByte
implements DataType<Byte> {
    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(Byte val) {
        return 1;
    }

    @Override
    public Class<Byte> encodedClass() {
        return Byte.class;
    }

    @Override
    public int skip(PositionedByteRange src) {
        src.setPosition(src.getPosition() + 1);
        return 1;
    }

    @Override
    public Byte decode(PositionedByteRange src) {
        byte val = src.getBytes()[src.getOffset() + src.getPosition()];
        this.skip(src);
        return val;
    }

    @Override
    public int encode(PositionedByteRange dst, Byte val) {
        Bytes.putByte(dst.getBytes(), dst.getOffset() + dst.getPosition(), val);
        return this.skip(dst);
    }

    public byte decodeByte(byte[] buff, int offset) {
        return buff[offset];
    }

    public int encodeByte(byte[] buff, int offset, byte val) {
        return Bytes.putByte(buff, offset, val);
    }
}

