/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
class BufferChain {
    private final ByteBuffer[] buffers;
    private int remaining = 0;
    private int bufferOffset = 0;

    BufferChain(ByteBuffer ... buffers) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(buffers.length);
        for (ByteBuffer b : buffers) {
            if (b == null) continue;
            bbs.add(b);
            this.remaining += b.remaining();
        }
        this.buffers = bbs.toArray(new ByteBuffer[bbs.size()]);
    }

    byte[] getBytes() {
        if (!this.hasRemaining()) {
            throw new IllegalAccessError();
        }
        byte[] bytes = new byte[this.remaining];
        int offset = 0;
        for (ByteBuffer bb : this.buffers) {
            System.arraycopy(bb.array(), bb.arrayOffset(), bytes, offset, bb.limit());
            offset += bb.capacity();
        }
        return bytes;
    }

    boolean hasRemaining() {
        return this.remaining > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long write(GatheringByteChannel channel, int chunkSize) throws IOException {
        int chunkRemaining = chunkSize;
        ByteBuffer lastBuffer = null;
        int bufCount = 0;
        int restoreLimit = -1;
        while (chunkRemaining > 0 && this.bufferOffset + bufCount < this.buffers.length) {
            lastBuffer = this.buffers[this.bufferOffset + bufCount];
            if (!lastBuffer.hasRemaining()) {
                ++this.bufferOffset;
                continue;
            }
            ++bufCount;
            if (lastBuffer.remaining() > chunkRemaining) {
                restoreLimit = lastBuffer.limit();
                lastBuffer.limit(lastBuffer.position() + chunkRemaining);
                chunkRemaining = 0;
                break;
            }
            chunkRemaining -= lastBuffer.remaining();
        }
        assert (lastBuffer != null);
        if (chunkRemaining == chunkSize) {
            assert (!this.hasRemaining());
            return 0L;
        }
        try {
            long ret = channel.write(this.buffers, this.bufferOffset, bufCount);
            if (ret > 0L) {
                this.remaining = (int)((long)this.remaining - ret);
            }
            long l = ret;
            return l;
        }
        finally {
            if (restoreLimit >= 0) {
                lastBuffer.limit(restoreLimit);
            }
        }
    }
}

