/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.http;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HttpConfig {
    private Policy policy;

    public HttpConfig(Configuration conf) {
        boolean sslEnabled = conf.getBoolean("hbase.ssl.enabled", false);
        Policy policy = this.policy = sslEnabled ? Policy.HTTPS_ONLY : Policy.HTTP_ONLY;
        if (sslEnabled) {
            conf.addResource("ssl-server.xml");
            conf.addResource("ssl-client.xml");
        }
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public boolean isSecure() {
        return this.policy == Policy.HTTPS_ONLY;
    }

    public String getSchemePrefix() {
        return this.isSecure() ? "https://" : "http://";
    }

    public String getScheme(Policy policy) {
        return policy == Policy.HTTPS_ONLY ? "https://" : "http://";
    }

    public static enum Policy {
        HTTP_ONLY,
        HTTPS_ONLY,
        HTTP_AND_HTTPS;


        public Policy fromString(String value) {
            if (HTTPS_ONLY.name().equalsIgnoreCase(value)) {
                return HTTPS_ONLY;
            }
            if (HTTP_AND_HTTPS.name().equalsIgnoreCase(value)) {
                return HTTP_AND_HTTPS;
            }
            return HTTP_ONLY;
        }

        public boolean isHttpEnabled() {
            return this == HTTP_ONLY || this == HTTP_AND_HTTPS;
        }

        public boolean isHttpsEnabled() {
            return this == HTTPS_ONLY || this == HTTP_AND_HTTPS;
        }
    }
}

