/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseTableMetadata
implements HoodieTableMetadata {
    private static final Logger LOG = LogManager.getLogger(BaseTableMetadata.class);
    static final long MAX_MEMORY_SIZE_IN_BYTES = 0x40000000L;
    static final int BUFFER_SIZE = 0xA00000;
    protected final transient HoodieEngineContext engineContext;
    protected final SerializableConfiguration hadoopConf;
    protected final String dataBasePath;
    protected final HoodieTableMetaClient dataMetaClient;
    protected final Option<HoodieMetadataMetrics> metrics;
    protected final HoodieMetadataConfig metadataConfig;
    protected final String spillableMapDirectory;
    protected boolean enabled;

    protected BaseTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String dataBasePath, String spillableMapDirectory) {
        this.engineContext = engineContext;
        this.hadoopConf = new SerializableConfiguration(engineContext.getHadoopConf());
        this.dataBasePath = dataBasePath;
        this.dataMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf.get()).setBasePath(dataBasePath).build();
        this.spillableMapDirectory = spillableMapDirectory;
        this.metadataConfig = metadataConfig;
        this.enabled = metadataConfig.enabled();
        this.metrics = metadataConfig.enableMetrics() ? Option.of(new HoodieMetadataMetrics(Registry.getRegistry("HoodieMetadata"))) : Option.empty();
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        if (this.enabled) {
            try {
                return this.fetchAllPartitionPaths();
            }
            catch (Exception e) {
                throw new HoodieMetadataException("Failed to retrieve list of partition from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.dataBasePath, this.metadataConfig.shouldAssumeDatePartitioning()).getAllPartitionPaths();
    }

    @Override
    public FileStatus[] getAllFilesInPartition(Path partitionPath) throws IOException {
        if (this.enabled) {
            try {
                return this.fetchAllFilesInPartition(partitionPath);
            }
            catch (Exception e) {
                throw new HoodieMetadataException("Failed to retrieve files in partition " + partitionPath + " from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.dataBasePath, this.metadataConfig.shouldAssumeDatePartitioning()).getAllFilesInPartition(partitionPath);
    }

    @Override
    public Map<String, FileStatus[]> getAllFilesInPartitions(List<String> partitions) throws IOException {
        if (this.enabled) {
            try {
                List<Path> partitionPaths = partitions.stream().map(entry -> new Path(entry)).collect(Collectors.toList());
                Map<String, FileStatus[]> partitionsFilesMap = this.fetchAllFilesInPartitionPaths(partitionPaths);
                return partitionsFilesMap;
            }
            catch (Exception e) {
                throw new HoodieMetadataException("Failed to retrieve files in partition from metadata", e);
            }
        }
        return new FileSystemBackedTableMetadata(this.getEngineContext(), this.hadoopConf, this.dataBasePath, this.metadataConfig.shouldAssumeDatePartitioning()).getAllFilesInPartitions(partitions);
    }

    protected List<String> fetchAllPartitionPaths() throws IOException {
        HoodieTimer timer = new HoodieTimer().startTimer();
        Option<HoodieRecord<HoodieMetadataPayload>> hoodieRecord = this.getRecordByKey("__all_partitions__", MetadataPartitionType.FILES.partitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_partitions", timer.endTimer()));
        List<String> partitions = Collections.emptyList();
        if (hoodieRecord.isPresent()) {
            this.mayBeHandleSpuriousDeletes(hoodieRecord, "\"all partitions\"");
            partitions = hoodieRecord.get().getData().getFilenames();
            if (partitions.contains(".")) {
                partitions.remove(".");
                partitions.add("");
            }
        }
        LOG.info((Object)("Listed partitions from metadata: #partitions=" + partitions.size()));
        return partitions;
    }

    FileStatus[] fetchAllFilesInPartition(Path partitionPath) throws IOException {
        String partitionName = FSUtils.getRelativePartitionPath(new Path(this.dataBasePath), partitionPath);
        if (partitionName.isEmpty()) {
            partitionName = ".";
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        Option<HoodieRecord<HoodieMetadataPayload>> hoodieRecord = this.getRecordByKey(partitionName, MetadataPartitionType.FILES.partitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        FileStatus[] statuses = new FileStatus[]{};
        if (hoodieRecord.isPresent()) {
            this.mayBeHandleSpuriousDeletes(hoodieRecord, partitionName);
            statuses = hoodieRecord.get().getData().getFileStatuses(this.hadoopConf.get(), partitionPath);
        }
        LOG.info((Object)("Listed file in partition from metadata: partition=" + partitionName + ", #files=" + statuses.length));
        return statuses;
    }

    Map<String, FileStatus[]> fetchAllFilesInPartitionPaths(List<Path> partitionPaths) throws IOException {
        HashMap<String, Path> partitionInfo = new HashMap<String, Path>();
        boolean foundNonPartitionedPath = false;
        for (Path partitionPath : partitionPaths) {
            String partitionName = FSUtils.getRelativePartitionPath(new Path(this.dataBasePath), partitionPath);
            if (partitionName.isEmpty()) {
                if (partitionInfo.size() > 1) {
                    throw new HoodieMetadataException("Found mix of partitioned and non partitioned paths while fetching data from metadata table");
                }
                partitionInfo.put(".", partitionPath);
                foundNonPartitionedPath = true;
                continue;
            }
            if (foundNonPartitionedPath) {
                throw new HoodieMetadataException("Found mix of partitioned and non partitioned paths while fetching data from metadata table");
            }
            partitionInfo.put(partitionName, partitionPath);
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> partitionsFileStatus = this.getRecordsByKeys(new ArrayList<String>(partitionInfo.keySet()), MetadataPartitionType.FILES.partitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        HashMap<String, FileStatus[]> result = new HashMap<String, FileStatus[]>();
        for (Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>> entry : partitionsFileStatus) {
            if (!entry.getValue().isPresent()) continue;
            this.mayBeHandleSpuriousDeletes(entry.getValue(), entry.getKey());
            result.put(((Path)partitionInfo.get(entry.getKey())).toString(), entry.getValue().get().getData().getFileStatuses(this.hadoopConf.get(), (Path)partitionInfo.get(entry.getKey())));
        }
        LOG.info((Object)("Listed files in partitions from metadata: partition list =" + Arrays.toString(partitionPaths.toArray())));
        return result;
    }

    private void mayBeHandleSpuriousDeletes(Option<HoodieRecord<HoodieMetadataPayload>> hoodieRecord, String partitionName) {
        if (!hoodieRecord.get().getData().getDeletions().isEmpty()) {
            if (!this.metadataConfig.ignoreSpuriousDeletes()) {
                throw new HoodieMetadataException("Metadata record for " + partitionName + " is inconsistent: " + hoodieRecord.get().getData());
            }
            LOG.warn((Object)("Metadata record for " + partitionName + " encountered some files to be deleted which was not added before. Ignoring the spurious deletes as the `" + HoodieMetadataConfig.IGNORE_SPURIOUS_DELETES.key() + "` config is set to false"));
        }
    }

    protected abstract Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKey(String var1, String var2);

    protected abstract List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> getRecordsByKeys(List<String> var1, String var2);

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext != null ? this.engineContext : new HoodieLocalEngineContext(this.hadoopConf.get());
    }

    public HoodieMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    protected String getLatestDataInstantTime() {
        return this.dataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp).orElse("00000000000000");
    }
}

